/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class PropDeriv
extends BlackBox {
    private double kp = 1.0;
    private double td = 0.0;
    private double kd = 0.0;

    public PropDeriv() {
        super("PropDeriv");
        this.sNumerDeg = 1;
        this.sDenomDeg = 0;
        super.setSnumer(new ComplexPoly(1.0, 0.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setKp(double kp) {
        this.kp = kp;
        this.sNumer.resetCoeff(0, new Complex(this.kp, 0.0));
        if (this.sZeros == null) {
            this.sZeros = Complex.oneDarray(1);
        }
        this.sZeros[0].reset(-this.kp / this.kd, 0.0);
        super.addDeadTimeExtras();
    }

    public void setKd(double kd) {
        this.kd = kd;
        this.td = kd / this.kp;
        this.sNumer.resetCoeff(1, new Complex(this.kd, 0.0));
        if (this.sZeros == null) {
            this.sZeros = Complex.oneDarray(1);
        }
        this.sZeros[0].reset(-this.kp / this.kd, 0.0);
        super.addDeadTimeExtras();
    }

    public void setTd(double td) {
        this.td = td;
        this.kd = this.td * this.kp;
        if (this.sZeros == null) {
            this.sZeros = Complex.oneDarray(1);
        }
        this.sNumer.resetCoeff(1, new Complex(this.kd, 0.0));
        this.sZeros[0].reset(-this.kp / this.kd, 0.0);
        super.addDeadTimeExtras();
    }

    public double getKp() {
        return this.kp;
    }

    public double getKd() {
        return this.kd;
    }

    public double getTd() {
        return this.td;
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in PropDeriv with a zero sampling period");
        }
        super.deadTimeWarning("zTransform");
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            this.zNumerDeg = 1;
            this.zDenomDeg = 1;
            this.zNumer = new ComplexPoly(-this.kd, this.kp * this.deltaT + this.kd);
            this.zDenom = new ComplexPoly(0.0, this.deltaT);
            this.zZeros = Complex.oneDarray(1);
            this.zZeros[0].reset(this.kd / (this.kp * this.deltaT + this.kd), 0.0);
            this.zPoles = Complex.oneDarray(1);
            this.zPoles[0].reset(0.0, 0.0);
        }
    }

    @Override
    public void zTransform(double deltaT) {
        super.setDeltaT(deltaT);
        super.deadTimeWarning("zTransform");
        this.zTransform();
    }

    @Override
    public void stepInput(double stepMag, double finalTime) {
        int i;
        int n = 51;
        double incrT = finalTime / (double)(n - 2);
        double[][] cdata = new double[2][n];
        cdata[0][0] = 0.0;
        cdata[1][0] = 0.0;
        for (int i2 = 2; i2 < n; ++i2) {
            cdata[0][i2] = cdata[0][i2 - 1] + incrT;
        }
        double kpterm = this.kp * stepMag;
        cdata[1][0] = 0.0;
        for (i = 1; i < n; ++i) {
            cdata[1][i] = kpterm;
        }
        if (this.deadTime != 0.0) {
            i = 0;
            while (i < n) {
                double[] dArray = cdata[0];
                int n2 = i++;
                dArray[n2] = dArray[n2] + this.deadTime;
            }
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
        pg.setGraphTitle2(this.getName());
        pg.setXaxisLegend("Time");
        pg.setXaxisUnitsName("s");
        pg.setYaxisLegend("Output");
        pg.setPoint(0);
        pg.setLine(3);
        pg.plot();
    }

    @Override
    public void stepInput(double finalTime) {
        this.stepInput(1.0, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, int rampOrder, double finalTime) {
        if (rampOrder == 0) {
            this.stepInput(rampGradient, finalTime);
        } else {
            int i;
            int n = 50;
            double incrT = finalTime / (double)(n - 1);
            double[][] cdata = new double[2][n];
            double sum = 0.0;
            cdata[0][0] = 0.0;
            cdata[1][0] = 0.0;
            for (i = 1; i < n; ++i) {
                cdata[0][i] = cdata[0][i - 1] + incrT;
                cdata[1][i] = rampGradient * Math.pow(cdata[0][i], rampOrder - 1) * (this.kp * cdata[0][i] + this.kd);
            }
            if (this.deadTime != 0.0) {
                i = 0;
                while (i < n) {
                    double[] dArray = cdata[0];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] + this.deadTime;
                }
            }
            PlotGraph pg = new PlotGraph(cdata);
            pg.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + rampGradient + " ramp order (n) = " + rampOrder);
            pg.setGraphTitle2(this.getName());
            pg.setXaxisLegend("Time");
            pg.setXaxisUnitsName("s");
            pg.setYaxisLegend("Output");
            pg.setPoint(0);
            pg.plot();
        }
    }

    @Override
    public void rampInput(int rampOrder, double finalTime) {
        double rampGradient = 1.0;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, double finalTime) {
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double finalTime) {
        double rampGradient = 1.0;
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public Complex getOutputS(Complex sValue, Complex iinput) {
        this.sValue = sValue;
        this.inputS = iinput;
        Complex term = this.sValue.times(this.kd);
        term = term.plus(this.kp);
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        Complex term = this.sValue.times(this.kd);
        term = term.plus(this.kp);
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double ttime, double inp) {
        super.setInputT(ttime, inp);
        this.calcOutputT();
    }

    public void calcOutputT() {
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
        int n = this.sampLen - 1;
        this.outputT[n] = this.outputT[n] + this.kd * (this.inputT[this.sampLen - 1] - this.inputT[this.sampLen - 2]) / this.deltaT;
    }

    public Complex[] getSpoles() {
        System.out.println("PD controller has no s-domain poles");
        return null;
    }

    @Override
    public PropDeriv copy() {
        if (this == null) {
            return null;
        }
        PropDeriv bb = new PropDeriv();
        this.copyBBvariables(bb);
        bb.kp = this.kp;
        bb.td = this.td;
        bb.kd = this.kd;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

