/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.AlleleFrequencyStats;
import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.stats.TsTvStats;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class VcfStats
implements SamplingStats<VcfEntry> {
    TsTvStats tsTvStats = new TsTvStats();
    TsTvStats tsTvStatsKnown = new TsTvStats();
    AlleleFrequencyStats alleleFrequencyStats = new AlleleFrequencyStats();
    AlleleFrequencyStats alleleFrequencyStatsKnown = new AlleleFrequencyStats();

    public AlleleFrequencyStats getAlleleFrequencyStats() {
        return this.alleleFrequencyStats;
    }

    public AlleleFrequencyStats getAlleleFrequencyStatsKnown() {
        return this.alleleFrequencyStatsKnown;
    }

    public TsTvStats getTsTvStats() {
        return this.tsTvStats;
    }

    public TsTvStats getTsTvStatsKnown() {
        return this.tsTvStatsKnown;
    }

    public String getAlleleFrequencyHistoUrl() {
        return this.alleleFrequencyStats.getCount().toStringPlot("Alleles frequencies", "Alleles", true);
    }

    @Override
    public boolean hasData() {
        return this.tsTvStats.hasData() || this.alleleFrequencyStats.hasData();
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (!vcfEntry.getId().isEmpty()) {
            this.tsTvStatsKnown.sample(vcfEntry);
            this.alleleFrequencyStatsKnown.sample(vcfEntry);
        }
        this.tsTvStats.sample(vcfEntry);
        this.alleleFrequencyStats.sample(vcfEntry);
    }
}

