/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class SnpEffPredictorFactory {
    public static final int MARK = 1000;
    public static boolean debug = false;
    boolean verbose = false;
    boolean readSequences = true;
    String fileName;
    String fastaFile;
    String line;
    int lineNum;
    Config config;
    Genome genome;
    SnpEffectPredictor snpEffectPredictor;
    int inOffset;
    int totalSeqsAdded = 0;
    int totalSeqsIgnored = 0;
    HashMap<String, Integer> exonsByChromo;
    HashMap<String, Marker> markersById;
    HashMap<String, Gene> genesById;
    HashMap<String, Transcript> transcriptsById;

    public SnpEffPredictorFactory(Config config, int inOffset) {
        this.config = config;
        this.inOffset = inOffset;
        this.genome = config.getGenome();
        this.snpEffectPredictor = new SnpEffectPredictor(config.getGenome());
        this.exonsByChromo = new HashMap();
        this.markersById = new HashMap();
        this.genesById = new HashMap();
        this.transcriptsById = new HashMap();
    }

    protected void add(Cds cds) {
        if (debug) {
            Gpr.debug("Adding CDS:\t" + cds);
        }
        Transcript tr = (Transcript)cds.getParent();
        tr.add(cds);
        this.addMarker(cds, false);
    }

    protected void add(Chromosome chromo) {
        this.genome.add(chromo);
    }

    protected void add(Exon exon) {
        Transcript tr;
        Exon oldex;
        if (debug) {
            Gpr.debug("Adding Exon:\t" + exon);
        }
        if ((oldex = (Exon)(tr = (Transcript)exon.getParent()).get(exon.getId())) != null) {
            if (oldex.includes(exon)) {
                return;
            }
            exon = new Exon(tr, exon.getStart(), exon.getEnd(), exon.getStrand(), exon.getId() + "_" + tr.subintervals().size(), exon.getRank());
        }
        tr.add(exon);
        this.addMarker(exon, false);
    }

    protected void add(Gene gene) {
        if (debug) {
            Gpr.debug("Adding Gene:\t" + gene.getId());
        }
        this.snpEffectPredictor.add(gene);
        if (this.genesById.containsKey(gene.getId())) {
            throw new RuntimeException("Gene  '" + gene.getId() + "' already exists");
        }
        this.genesById.put(gene.getId(), gene);
    }

    protected void add(Marker marker) {
        this.addMarker(marker, false);
    }

    protected void add(Transcript tr) {
        if (debug) {
            Gpr.debug("Adding Transcript:\t" + tr.getId());
        }
        Gene gene = (Gene)tr.getParent();
        gene.add(tr);
        if (this.transcriptsById.containsKey(tr.getId())) {
            throw new RuntimeException("Transcript  '" + tr.getId() + "' already exists");
        }
        this.transcriptsById.put(tr.getId(), tr);
    }

    protected void addExonSequences(String chr, String chrSeq) {
        int seqsAdded = 0;
        int seqsIgnored = 0;
        System.out.print("\t\tAdding genomic sequences to exons: ");
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.getChromosomeName().equalsIgnoreCase(chr)) continue;
            for (Transcript tr : gene) {
                for (Exon exon : tr) {
                    int ssStart = exon.getStart();
                    int ssEnd = exon.getEnd() + 1;
                    if (ssStart < 0 || ssEnd > chrSeq.length()) {
                        System.err.println("Ignoring exon outside chromosome range (chromo length: " + chrSeq.length() + "). Exon: " + exon);
                        ++seqsIgnored;
                        continue;
                    }
                    try {
                        String seq = chrSeq.substring(ssStart, ssEnd).toUpperCase();
                        if (exon.isStrandMinus()) {
                            seq = GprSeq.reverseWc(seq);
                        }
                        exon.setSequence(seq);
                        ++seqsAdded;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new RuntimeException("Error trying to add sequence to exon:\n\tChromosome sequence length: " + chrSeq.length() + "\n\tExon: " + exon);
                    }
                }
            }
        }
        System.out.println("\tDone (" + seqsAdded + " sequences added, " + seqsIgnored + " ignored).");
        this.totalSeqsAdded += seqsAdded;
        this.totalSeqsIgnored += seqsIgnored;
    }

    protected void addMarker(Marker marker, boolean unique) {
        String key = marker.getId();
        if (unique && this.markersById.containsKey(key)) {
            throw new RuntimeException("Marker '" + key + "' already exists");
        }
        this.markersById.put(key, marker);
    }

    protected void adjustChromosomes() {
        HashMap<String, Integer> lenByChr = new HashMap<String, Integer>();
        for (Gene gene : this.config.getGenome().getGenes()) {
            String chrName = gene.getChromosomeName();
            Integer len = (Integer)lenByChr.get(chrName);
            int max = Math.max(gene.getEnd(), len != null ? len : 0);
            lenByChr.put(chrName, max);
        }
        for (String chrName : lenByChr.keySet()) {
            this.config.getGenome().getChromosome(chrName).setEnd((Integer)lenByChr.get(chrName));
        }
    }

    protected void beforeExonSequences() {
        this.exonsFromCds();
        this.deleteRedundant();
        this.collapseZeroGap();
    }

    void chromoLen(String chromoName, int len) {
        Chromosome chromo = this.getOrCreateChromosome(chromoName);
        chromo.setLength(len);
    }

    protected void collapseZeroGap() {
        System.out.print("\n\tCollapsing zero length introns (if needed): ");
        int count = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.collapseZeroGap()) continue;
                ++count;
                System.out.print('.');
            }
        }
        System.out.println("\n\tTotal collapsed transcripts: " + count);
    }

    void countExonsByChromo() {
        this.exonsByChromo = new HashMap();
        for (Gene gint : this.genome.getGenes()) {
            Chromosome chromo = gint.getChromosome();
            for (Transcript tint : gint) {
                for (Exon eint : tint) {
                    String chromoName = chromo.getId();
                    Integer count = this.exonsByChromo.get(chromoName);
                    if (count == null) {
                        count = 1;
                    } else {
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                    }
                    this.exonsByChromo.put(chromoName, count);
                }
            }
        }
    }

    public abstract SnpEffectPredictor create();

    protected void deleteRedundant() {
        System.out.print("\n\tDeleting redundant exons (if needed): ");
        int count = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.deleteRedundant()) continue;
                ++count;
                System.out.print('.');
            }
        }
        System.out.println("\n\tTotal transcripts with deleted exons: " + count);
    }

    void error(String msg) {
        throw new RuntimeException("FATAL ERROR: " + msg + ". File '" + this.fileName + "' line " + this.lineNum + "\n\t'" + this.line + "'\n");
    }

    protected void exonsFromCds() {
        System.out.print("\n\tCreate exons from CDS (if needed): ");
        int count = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                int lenCds = 0;
                for (Cds cds : tr.getCds()) {
                    lenCds += cds.size();
                }
                int lenExons = 0;
                for (Exon ex : tr) {
                    lenExons += ex.size();
                }
                if (lenCds <= lenExons) continue;
                this.exonsFromCds(tr);
                ++count;
            }
        }
        System.out.println("\n\tExons created for " + count + " transcripts.");
    }

    protected void exonsFromCds(Transcript tr) {
        List<Cds> cdss = tr.getCds();
        int trStrand = tr.getStrand() >= 0 ? 1 : -1;
        int cdsStrand = 0;
        for (Cds cds : cdss) {
            cdsStrand += cds.getStrand();
        }
        int n = cdsStrand = cdsStrand >= 0 ? 1 : -1;
        if (cdsStrand != trStrand) {
            System.out.print(cdsStrand >= 0 ? (char)'+' : '-');
            tr.setStrand(cdsStrand);
        }
        if (tr.getStrand() >= 0) {
            Collections.sort(cdss, new IntervalComparatorByStart());
        } else {
            Collections.sort(cdss, new IntervalComparatorByEnd(true));
        }
        int rank = 1;
        for (Cds cds : cdss) {
            String id = "Exon_" + cds.getChromosomeName() + "_" + cds.getStart() + "_" + cds.getEnd();
            if (tr.get(id) == null) {
                Exon exon = new Exon(tr, cds.getStart(), cds.getEnd(), trStrand, id, rank);
                tr.add(exon);
            }
            ++rank;
            System.out.print('.');
        }
    }

    protected Gene findGene(String id) {
        Gene gene = this.genesById.get(id);
        if (gene != null) {
            return gene;
        }
        return this.genesById.get("Gene_" + id);
    }

    protected Gene findGene(String geneId, String id) {
        Gene gene = this.findGene(geneId);
        if (gene != null) {
            return gene;
        }
        return this.genesById.get("Gene_" + id);
    }

    protected Marker findMarker(String id) {
        return this.markersById.get(id);
    }

    protected Transcript findTranscript(String id) {
        Transcript tr = this.transcriptsById.get(id);
        if (tr != null) {
            return tr;
        }
        return this.transcriptsById.get("Transcript_" + id);
    }

    protected Transcript findTranscript(String trId, String id) {
        Transcript tr = this.findTranscript(trId);
        if (tr != null) {
            return tr;
        }
        return this.transcriptsById.get("Transcript_" + id);
    }

    void finishUp(boolean verbose) {
        int showEvery = 100;
        int i = 1;
        System.out.print("\n\tAdjusting genes: ");
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.adjust()) continue;
            Gpr.showMark(i++, showEvery);
        }
        System.out.print("\n\tAdjusting chromosome sizes: ");
        for (Gene gene : this.genome.getGenes()) {
            Chromosome chr = gene.getChromosome();
            if (gene.getEnd() <= chr.getEnd()) continue;
            chr.setLength(gene.getEnd() + 1);
            Gpr.showMark(i++, showEvery);
        }
        this.removerSuspiciousTranscripts(showEvery);
        i = 1;
        System.out.print("\n\tAdjusting transcripts: ");
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.adjust()) continue;
                Gpr.showMark(i++, showEvery);
            }
        }
        i = 1;
        System.out.print("\n\tRanking exons: ");
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.rankExons()) continue;
                Gpr.showMark(i++, showEvery);
            }
        }
        System.out.print("\n\tCreate UTRs from CDS (if needed): ");
        this.utrFromCds(verbose, showEvery);
        this.removeEmptyChromos();
        System.out.println("");
    }

    protected Chromosome getOrCreateChromosome(String chromoName) {
        Chromosome chromo = this.genome.getChromosome(chromoName);
        if (chromo == null) {
            chromo = new Chromosome(this.genome, 0, 0, 1, chromoName);
            this.genome.add(chromo);
        }
        return chromo;
    }

    boolean hasExons(String chromoName) {
        Integer count = this.exonsByChromo.get(chromoName);
        return count != null && count > 0;
    }

    protected int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - this.inOffset;
    }

    protected void readExonSequences() {
        List<String> files = this.config.getFileListGenomeFasta();
        if (this.fastaFile != null) {
            files.clear();
            files.add(this.fastaFile);
        }
        for (String file : files) {
            System.out.println("\t\tTrying FASTA file: '" + file + "'");
            if (!Gpr.canRead(file)) continue;
            FastaFileIterator ffi = new FastaFileIterator(file);
            for (String seq : ffi) {
                String chromo = ffi.getName();
                System.out.println("\t\tReading sequence '" + chromo + "', length: " + seq.length());
                Chromosome chromoInt = this.getOrCreateChromosome(chromo);
                chromoInt.setLength(seq.length());
                this.addExonSequences(chromo, seq);
            }
            return;
        }
        throw new RuntimeException("Cannot find reference sequence.");
    }

    void removeEmptyChromos() {
        System.out.println("\n\tRemove empty chromosomes: ");
        ArrayList<Chromosome> chrToDelete = new ArrayList<Chromosome>();
        for (Chromosome chr : this.config.getGenome()) {
            if (chr.size() > 1) continue;
            chrToDelete.add(chr);
        }
        for (Chromosome chr : chrToDelete) {
            System.out.println("\t\tRemoving empty chromosome: '" + chr.getId() + "'");
            this.config.getGenome().remove(chr);
        }
        if (chrToDelete.size() > 0) {
            System.out.print("\t\tChromosome left: ");
            for (Chromosome chr : this.config.getGenome()) {
                System.out.print(chr.getId() + " ");
            }
            System.out.println("");
        }
    }

    void removerSuspiciousTranscripts(int showEvery) {
        System.out.print("\n\tUpdating frame info from CDSs to Exons.");
        int i = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                for (Exon ex : tr) {
                    if (ex.getFrame() >= 0) continue;
                    for (Cds cds : tr.getCds()) {
                        if (ex.getStart() != cds.getStart() || ex.getEnd() != cds.getEnd()) continue;
                        ex.setFrame(cds.getFrame());
                    }
                }
            }
        }
        i = 1;
        System.out.print("\n\tFiltering out suspicious transcripts (first exon has non-zero frame): ");
        LinkedList<Transcript> trToDelete = new LinkedList<Transcript>();
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                Exon exon;
                List exons = tr.sortedStrand();
                if (exons == null || exons.isEmpty() || (exon = (Exon)exons.get(0)).getFrame() <= 0) continue;
                trToDelete.add(tr);
                Gpr.showMark(i++, showEvery);
            }
        }
        for (Transcript tr : trToDelete) {
            Gene gene = (Gene)tr.getParent();
            gene.remove(tr);
        }
        System.out.print((trToDelete.size() > 0 ? "\n" : "") + "\tTotal: " + trToDelete.size() + " removed.");
    }

    public void setFastaFile(String fastaFile) {
        this.fastaFile = fastaFile;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setReadSequences(boolean readSequences) {
        this.readSequences = readSequences;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    String unquote(String qstr) {
        return qstr.replaceAll("\"", "");
    }

    void utrFromCds(boolean verbose, int showEvery) {
        int i = 1;
        for (Gene gint : this.genome.getGenes()) {
            for (Transcript tint : gint) {
                boolean show = tint.utrFromCds(verbose);
                if (!show || verbose) continue;
                Gpr.showMarkStderr(i++, showEvery);
            }
        }
    }

    void warning(String msg) {
        if (this.verbose) {
            System.err.println("WARNING: " + msg + ". File '" + this.fileName + "' line " + this.lineNum + "\t'" + this.line + "'");
        }
    }
}

