/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.Collection;
import java.util.HashMap;

public class PlinkMap {
    public static boolean debug = false;
    HashMap<String, Integer> genotypeNames = new HashMap();
    String[] chrNames;
    int[] positions;
    String[] ids;

    public String getChrName(int idx) {
        return this.chrNames[idx];
    }

    public String getId(int idx) {
        return this.ids[idx];
    }

    public Collection<String> getGenotypeNames() {
        return this.genotypeNames.keySet();
    }

    public Integer getGenotypeNames(String idStr) {
        return this.genotypeNames.get(idStr);
    }

    public int getPosition(int idx) {
        return this.positions[idx];
    }

    public void read(String mapFileName) {
        String cols = Gpr.readFile(mapFileName);
        String[] lines = cols.split("\n");
        this.positions = new int[lines.length];
        this.chrNames = new String[lines.length];
        this.ids = new String[lines.length];
        int lineNum = 0;
        for (String line : lines) {
            String[] fields = line.split("\\s");
            this.chrNames[lineNum] = fields[0];
            this.ids[lineNum] = fields[1];
            this.positions[lineNum] = Gpr.parseIntSafe(fields[fields.length - 1]);
            if (!this.ids[lineNum].isEmpty()) {
                if (this.genotypeNames.containsKey(this.ids)) {
                    throw new RuntimeException("Duplicate ID '" + this.ids[lineNum] + "'. File '" + mapFileName + "', line '" + (lineNum + 1) + "'");
                }
                this.genotypeNames.put(this.ids[lineNum], lineNum);
                if (debug) {
                    Gpr.debug("genotypeNames.put(" + this.ids[lineNum] + ", " + lineNum + ")");
                }
            }
            ++lineNum;
        }
    }

    public int size() {
        return this.positions.length;
    }
}

