/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.overlap;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.binseq.coder.Coder;

public class SequenceRotator {
    DnaSequence sequence;
    DnaSequence[] rotations;
    Coder coder;

    public SequenceRotator(DnaSequence sequence) {
        this.sequence = sequence;
        this.coder = sequence.getCoder();
        this.rotations = new DnaSequence[this.coder.basesPerWord()];
        for (int i = 0; i < this.rotations.length; ++i) {
            this.rotations[i] = null;
        }
        this.rotations[0] = sequence;
    }

    public DnaSequence calcRor(int rotate) {
        if (rotate <= 0 && rotate >= this.coder.basesPerWord()) {
            throw new RuntimeException("Invalid parameter rotate=" + rotate + ". It should be a number between 1 and " + this.coder.basesPerWord());
        }
        long[] bits = this.sequence.getCodes();
        long[] newBits = new long[bits.length + 1];
        int ror = 2 * rotate;
        int rol = 2 * (this.coder.basesPerWord() - rotate);
        for (int i = 0; i < newBits.length; ++i) {
            if (i < bits.length) {
                newBits[i] = bits[i] >>> ror;
            }
            if (i <= 0) continue;
            int n = i;
            newBits[n] = newBits[n] | bits[i - 1] << rol;
        }
        DnaSequence binSeq = new DnaSequence(this.sequence.length() + rotate, newBits);
        return binSeq;
    }

    DnaSequence ror(int rotate) {
        if (this.rotations[rotate] == null) {
            this.rotations[rotate] = this.calcRor(rotate);
        }
        return this.rotations[rotate];
    }

    public DnaSequence rotate(int rotate) {
        if (rotate <= -this.coder.basesPerWord() || rotate >= this.coder.basesPerWord()) {
            throw new RuntimeException("Parameter 'rotate' should be in the range [" + (-this.coder.basesPerWord() + 1) + " , " + (this.coder.basesPerWord() - 1) + ")");
        }
        if (rotate < 0) {
            return this.ror(this.coder.basesPerWord() + rotate);
        }
        if (rotate > 0) {
            return this.ror(rotate);
        }
        return this.sequence;
    }
}

