/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.LossOfFunction;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class VcfOutputFormatter
extends OutputFormatter {
    public static final boolean debug = false;
    public static final String VCF_INFO_EFF_NAME = "EFF";
    public static final String VCF_INFO_LOF_NAME = "LOF";
    public static final String VCF_INFO_NMD_NAME = "NMD";
    boolean needAddInfo = false;
    boolean needAddHeader = true;
    VcfEffect.FormatVersion formatVersion = VcfEffect.FormatVersion.FORMAT_SNPEFF_3;
    List<VcfEntry> vcfEntries;
    boolean lossOfFunction;
    Genome genome;

    protected VcfOutputFormatter() {
    }

    public VcfOutputFormatter(Genome genome, VcfEffect.FormatVersion formatVersion) {
        this.genome = genome;
        this.formatVersion = formatVersion;
    }

    public VcfOutputFormatter(List<VcfEntry> vcfEntries) {
        this.vcfEntries = vcfEntries;
    }

    protected void addHeader() {
        VcfEntry vcfEntry = (VcfEntry)this.section;
        VcfFileIterator vcfFile = vcfEntry.getVcfFileIterator();
        for (String newHeaderLine : this.getNewHeaderLines()) {
            vcfFile.getVcfHeader().addLine(newHeaderLine);
        }
        this.needAddHeader = false;
    }

    protected void addInfo(VcfEntry vcfEntry) {
        if (this.changeEffects.isEmpty()) {
            return;
        }
        HashSet<String> effs = new HashSet<String>();
        for (ChangeEffect changeEffect : this.changeEffects) {
            if (this.changeEffectResutFilter != null && this.changeEffectResutFilter.filter(changeEffect)) continue;
            StringBuilder effBuff = new StringBuilder();
            effBuff.append(changeEffect.effect(true, false, false));
            effBuff.append("(");
            effBuff.append((Object)changeEffect.getEffectImpact());
            effBuff.append("|");
            ChangeEffect.FunctionalClass fc = changeEffect.getFunctionalClass();
            effBuff.append(fc == ChangeEffect.FunctionalClass.NONE ? "" : fc.toString());
            effBuff.append("|");
            effBuff.append(changeEffect.getCodonChange());
            effBuff.append("|");
            effBuff.append(changeEffect.getAaChangeHgvs());
            effBuff.append("|");
            if (this.formatVersion != VcfEffect.FormatVersion.FORMAT_SNPEFF_2) {
                int aalen = changeEffect.getAaLength();
                effBuff.append(aalen >= 0 ? Integer.valueOf(aalen) : "");
                effBuff.append("|");
            }
            Gene gene = changeEffect.getGene();
            Transcript tr = changeEffect.getTranscript();
            if (gene != null) {
                effBuff.append(this.vcfInfoSafeString(gene.getGeneName()));
                effBuff.append("|");
                effBuff.append(tr != null ? tr.getBioType() : "");
                effBuff.append("|");
                String coding = "";
                if (gene.getGenome().hasCodingInfo()) {
                    coding = gene.isProteinCoding() ? ChangeEffect.Coding.CODING.toString() : ChangeEffect.Coding.NON_CODING.toString();
                }
                effBuff.append(coding);
                effBuff.append("|");
            } else if (changeEffect.isRegulation()) {
                Regulation reg = (Regulation)changeEffect.getMarker();
                effBuff.append("|" + reg.getCellType() + "||");
            } else if (changeEffect.isCustom()) {
                Marker m = changeEffect.getMarker();
                if (m != null) {
                    effBuff.append("|" + m.getId() + "||");
                } else {
                    effBuff.append("|||");
                }
            } else {
                effBuff.append("|||");
            }
            if (tr != null) {
                effBuff.append(this.vcfInfoSafeString(tr.getId()));
            }
            effBuff.append("|");
            Exon ex = changeEffect.getExon();
            int rank = -1;
            if (ex != null) {
                rank = ex.getRank();
            } else {
                Intron intron = changeEffect.getIntron();
                if (intron != null) {
                    rank = intron.getRank();
                }
            }
            effBuff.append(rank >= 0 ? Integer.valueOf(rank) : "");
            if (!changeEffect.getWarning().isEmpty()) {
                effBuff.append("|" + changeEffect.getWarning());
            }
            if (!changeEffect.getError().isEmpty()) {
                effBuff.append("|" + changeEffect.getError());
            }
            effBuff.append(")");
            if (effs.add(effBuff.toString())) continue;
        }
        ArrayList listEffs = new ArrayList(effs);
        Collections.sort(listEffs);
        StringBuffer sbEffs = new StringBuffer();
        for (String eff : listEffs) {
            sbEffs.append(eff + ",");
        }
        if (sbEffs.length() > 0) {
            sbEffs.deleteCharAt(sbEffs.length() - 1);
        }
        vcfEntry.addInfo(VCF_INFO_EFF_NAME, sbEffs.toString());
        if (this.lossOfFunction) {
            LossOfFunction lof = new LossOfFunction(this.changeEffects);
            if (lof.isLof()) {
                vcfEntry.addInfo(VCF_INFO_LOF_NAME, lof.vcfLofValue());
            }
            if (lof.isNmd()) {
                vcfEntry.addInfo(VCF_INFO_NMD_NAME, lof.vcfNmdValue());
            }
        }
        this.needAddInfo = false;
    }

    @Override
    public OutputFormatter clone() {
        try {
            VcfOutputFormatter newOutputFormatter = (VcfOutputFormatter)super.clone();
            newOutputFormatter.formatVersion = this.formatVersion;
            newOutputFormatter.needAddInfo = this.needAddInfo;
            newOutputFormatter.needAddHeader = this.needAddHeader;
            newOutputFormatter.lossOfFunction = this.lossOfFunction;
            newOutputFormatter.genome = this.genome;
            return newOutputFormatter;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String endSection(Marker marker) {
        if (marker instanceof VcfEntry) {
            if (this.vcfEntries != null) {
                this.vcfEntries.add((VcfEntry)marker);
            }
            return super.endSection(marker);
        }
        return null;
    }

    public List<String> getNewHeaderLines() {
        ArrayList<String> newLines = new ArrayList<String>();
        newLines.add("##SnpEffVersion=\"" + this.version + "\"");
        newLines.add("##SnpEffCmd=\"" + this.commandLineStr + "\"");
        newLines.add("##INFO=<ID=EFF,Number=.,Type=String,Description=\"Predicted effects for this variant.Format: 'Effect ( Effect_Impact | Functional_Class | Codon_Change | Amino_Acid_change| Amino_Acid_length | Gene_Name | Gene_BioType | Coding | Transcript | Exon [ | ERRORS | WARNINGS ] )' \">");
        if (this.lossOfFunction) {
            newLines.add("##INFO=<ID=LOF,Number=.,Type=String,Description=\"Predicted loss of function effects for this variant. Format: 'Gene_Name | Gene_ID | Number_of_transcripts_in_gene | Percent_of_transcripts_affected' \">");
            newLines.add("##INFO=<ID=NMD,Number=.,Type=String,Description=\"Predicted nonsense mediated decay effects for this variant. Format: 'Gene_Name | Gene_ID | Number_of_transcripts_in_gene | Percent_of_transcripts_affected' \">");
        }
        return newLines;
    }

    public void setLossOfFunction(boolean lossOfFunction) {
        this.lossOfFunction = lossOfFunction;
    }

    @Override
    public void startSection(Marker marker) {
        if (marker instanceof VcfEntry) {
            super.startSection(marker);
        }
        this.needAddInfo = true;
    }

    @Override
    public String toString() {
        VcfEntry vcfEntry = (VcfEntry)this.section;
        if (this.needAddInfo) {
            this.addInfo(vcfEntry);
        }
        return vcfEntry.toString();
    }

    @Override
    protected String toStringHeader() {
        if (this.needAddHeader) {
            this.addHeader();
        }
        VcfEntry vcfEntry = (VcfEntry)this.section;
        VcfFileIterator vcfFile = vcfEntry.getVcfFileIterator();
        return vcfFile.getVcfHeader().toString();
    }

    public String vcfInfoSafeString(String value) {
        if (value == null) {
            return value;
        }
        value = value.replaceAll("[ ,;|=()]", "_");
        return value;
    }
}

