/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.collections;

public final class ArrayUtil {
    public static int getNextSize(int targetSize) {
        return (targetSize >> 3) + (targetSize < 9 ? 3 : 6) + targetSize;
    }

    public static int getShrinkSize(int currentSize, int targetSize) {
        int newSize = ArrayUtil.getNextSize(targetSize);
        if (newSize < currentSize / 2) {
            return newSize;
        }
        return currentSize;
    }

    public static byte[] grow(byte[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static byte[] grow(byte[] array, int minSize) {
        if (array.length < minSize) {
            byte[] newArray = new byte[ArrayUtil.getNextSize(minSize)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static int[] grow(int[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static int[] grow(int[] array, int minSize) {
        if (array.length < minSize) {
            int[] newArray = new int[ArrayUtil.getNextSize(minSize)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static long[] grow(long[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static long[] grow(long[] array, int minSize) {
        if (array.length < minSize) {
            long[] newArray = new long[ArrayUtil.getNextSize(minSize)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static int hashCode(byte[] array, int start, int end) {
        int code = 0;
        for (int i = end - 1; i >= start; --i) {
            code = code * 31 + array[i];
        }
        return code;
    }

    public static int hashCode(char[] array, int start, int end) {
        int code = 0;
        for (int i = end - 1; i >= start; --i) {
            code = code * 31 + array[i];
        }
        return code;
    }

    private static int parse(char[] chars, int offset, int len, int radix, boolean negative) throws NumberFormatException {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit(chars[i + offset], radix);
            if (digit == -1) {
                throw new NumberFormatException("Unable to parse");
            }
            if (max > result) {
                throw new NumberFormatException("Unable to parse");
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException("Unable to parse");
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException("Unable to parse");
        }
        return result;
    }

    public static int parseInt(char[] chars) throws NumberFormatException {
        return ArrayUtil.parseInt(chars, 0, chars.length, 10);
    }

    public static int parseInt(char[] chars, int offset, int len) throws NumberFormatException {
        return ArrayUtil.parseInt(chars, offset, len, 10);
    }

    public static int parseInt(char[] chars, int offset, int len, int radix) throws NumberFormatException {
        boolean negative;
        if (chars == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int i = 0;
        if (len == 0) {
            throw new NumberFormatException("chars length is 0");
        }
        boolean bl = negative = chars[offset + i] == '-';
        if (negative && ++i == len) {
            throw new NumberFormatException("can't convert to an int");
        }
        if (negative) {
            ++offset;
            --len;
        }
        return ArrayUtil.parse(chars, offset, len, radix, negative);
    }

    public static byte[] shrink(byte[] array, int targetSize) {
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize);
        if (newSize != array.length) {
            byte[] newArray = new byte[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static int[] shrink(int[] array, int targetSize) {
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize);
        if (newSize != array.length) {
            int[] newArray = new int[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static long[] shrink(long[] array, int targetSize) {
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize);
        if (newSize != array.length) {
            long[] newArray = new long[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }
}

