/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.codons;

import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class CodonTable {
    String name;
    HashMap<String, String> codon2aa;
    HashMap<String, String> aa2codon;
    HashSet<String> startCodons;
    HashSet<String> stopCodons;
    HashMap<String, Integer> degeneracy;

    public CodonTable(String name, String table) {
        this.name = name;
        this.codon2aa = new HashMap();
        this.aa2codon = new HashMap();
        this.startCodons = new HashSet();
        this.stopCodons = new HashSet();
        this.parse(table);
        this.calcDegeneracy();
    }

    public String aa(String codons) {
        char[] bases = codons.toCharArray();
        StringBuilder aas = new StringBuilder();
        int i = 0;
        while (i < bases.length) {
            String cod = "";
            for (int j = 0; j < 3 && i < bases.length; ++j, ++i) {
                cod = cod + bases[i];
            }
            String aa = this.codon2aa.get(cod.toUpperCase());
            if (aa == null) {
                aa = "?";
            }
            aas.append(aa);
        }
        return aas.toString();
    }

    void calcDegeneracy() {
        this.degeneracy = new HashMap();
        for (char base1 : DnaCoder.TO_BASE) {
            for (char base2 : DnaCoder.TO_BASE) {
                for (char base3 : DnaCoder.TO_BASE) {
                    char[] c = new char[]{base1, base2, base3};
                    String codonStrOld = new String(c);
                    String aaOld = this.aa(codonStrOld);
                    for (int pos = 0; pos < 3; ++pos) {
                        int count = 0;
                        for (char baseNew : DnaCoder.TO_BASE) {
                            char[] codon = new char[]{base1, base2, base3};
                            codon[pos] = baseNew;
                            String codonStrNew = new String(codon);
                            String aaNew = this.aa(codonStrNew);
                            if (!aaOld.equals(aaNew)) continue;
                            ++count;
                        }
                        String key = codonStrOld.toUpperCase() + "_" + pos;
                        this.degeneracy.put(key, count);
                    }
                }
            }
        }
    }

    public String codon(String aa) {
        String codon = this.aa2codon.get(aa.toUpperCase());
        if (codon == null) {
            return "???";
        }
        return codon;
    }

    public int degenerate(String codon, int pos) {
        String key = codon.toUpperCase() + "_" + pos;
        Integer degLevel = this.degeneracy.get(key);
        return degLevel != null ? degLevel : -1;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStart(String codon) {
        if (codon.length() == 3) {
            return this.startCodons.contains(codon.toUpperCase());
        }
        for (int i = 0; i < codon.length(); i += 3) {
            int max = Math.min(codon.length(), i + 3);
            String codonSigle = codon.substring(i, max);
            if (!this.startCodons.contains(codonSigle.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isStartFirst(String codon) {
        if (codon.length() < 3) {
            return false;
        }
        return this.isStart(codon.substring(0, 3));
    }

    public boolean isStop(String codon) {
        if (codon.length() == 3) {
            return this.stopCodons.contains(codon.toUpperCase());
        }
        for (int i = 0; i < codon.length(); i += 3) {
            int max = Math.min(codon.length(), i + 3);
            String codonSigle = codon.substring(i, max);
            if (!this.stopCodons.contains(codonSigle.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    void parse(String table) {
        String[] entries;
        table = table.toUpperCase();
        for (String entry : entries = table.split(",")) {
            if ((entry = entry.trim()).length() <= 0) continue;
            String[] t = entry.split("/");
            if (t.length == 2) {
                String codon = t[0];
                String aa = t[1];
                if (aa.indexOf(43) >= 0) {
                    this.startCodons.add(codon);
                    aa = aa.replaceAll("\\+", "");
                }
                if (aa.indexOf(42) >= 0) {
                    this.stopCodons.add(codon);
                }
                this.aa2codon.put(aa, codon);
                this.codon2aa.put(codon, aa);
                continue;
            }
            throw new RuntimeException("Error reading codon table. Cannot parse entry: '" + entry + "'\n\tTable: '" + table + "'");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("codon." + this.name + ": ");
        ArrayList<String> codons = new ArrayList<String>();
        codons.addAll(this.codon2aa.keySet());
        Collections.sort(codons);
        for (String codon : codons) {
            sb.append(" " + codon + "/" + this.aa(codon) + (this.isStart(codon) ? "+" : "") + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

