/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.akka.vcf;

import akka.actor.Props;
import ca.mcgill.mcb.pcingola.akka.Master;
import ca.mcgill.mcb.pcingola.akka.msg.StartMaster;
import ca.mcgill.mcb.pcingola.akka.vcf.StartMasterVcf;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class MasterVcf<T>
extends Master<VcfEntry, T> {
    protected boolean parseNow = true;
    protected boolean showHeader = true;
    protected String[] addHeader;
    protected VcfFileIterator vcfFileIterator;

    public MasterVcf(Props props, int numWorkers) {
        super(props, numWorkers);
    }

    @Override
    public boolean hasNext() {
        return this.vcfFileIterator.hasNext();
    }

    @Override
    public VcfEntry next() {
        return (VcfEntry)this.vcfFileIterator.next();
    }

    public void setAddHeader(String[] addHeader) {
        this.addHeader = addHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    @Override
    protected void startMaster(StartMaster startMaster) {
        try {
            super.startMaster(startMaster);
            StartMasterVcf startMasterVcf = (StartMasterVcf)startMaster;
            this.vcfFileIterator = new VcfFileIterator(startMasterVcf.vcfFileName);
            this.vcfFileIterator.setParseNow(this.parseNow);
            if (this.showHeader) {
                String headerStr;
                this.vcfFileIterator.readHeader();
                if (this.addHeader != null) {
                    for (String add : this.addHeader) {
                        this.vcfFileIterator.getVcfHeader().addLine(add);
                    }
                }
                if (!(headerStr = this.vcfFileIterator.getVcfHeader().toString()).isEmpty()) {
                    System.out.println(headerStr);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.shutdown();
        }
    }
}

