/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.TagValueAndUnsignedArrayFlag;
import htsjdk.samtools.util.DateParser;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.StringUtil;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class TextTagCodec {
    private static final int NUM_TAG_FIELDS = 3;
    private final String[] fields = new String[3];

    public String encode(String string, Object object) {
        long l;
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(':');
        char c = BinaryTagCodec.getTagValueType(object);
        switch (c) {
            case 'C': 
            case 'I': 
            case 'S': 
            case 'c': 
            case 's': {
                c = 'i';
            }
        }
        if (c == 'H') {
            object = StringUtil.bytesToHexString((byte[])object);
        } else if (c == 'B') {
            object = this.getArrayType(object, false) + "," + this.encodeArrayValue(object);
        } else if (c == 'i' && ((l = ((Number)object).longValue()) < Integer.MIN_VALUE || l > 0xFFFFFFFFL)) {
            throw new IllegalArgumentException("Value for tag " + string + " cannot be stored in either a signed or unsigned 32-bit integer: " + l);
        }
        stringBuilder.append(c);
        stringBuilder.append(':');
        stringBuilder.append(object.toString());
        return stringBuilder.toString();
    }

    private char getArrayType(Object object, boolean bl) {
        int n;
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Float.TYPE) {
            if (bl) {
                throw new IllegalArgumentException("float array cannot be unsigned");
            }
            return 'f';
        }
        if (clazz == Byte.TYPE) {
            n = 99;
        } else if (clazz == Short.TYPE) {
            n = 115;
        } else if (clazz == Integer.TYPE) {
            n = 105;
        } else {
            throw new IllegalArgumentException("Unrecognized array type " + clazz);
        }
        return (char)((int)(bl ? Character.toUpperCase((char)n) : n));
    }

    private String encodeArrayValue(Object object) {
        StringBuilder stringBuilder = new StringBuilder(Array.get(object, 0).toString());
        int n = Array.getLength(object);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(Array.get(object, i).toString());
        }
        return stringBuilder.toString();
    }

    private long[] widenToUnsigned(Object object) {
        long l;
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            l = 255L;
        } else if (clazz == Short.TYPE) {
            l = 65535L;
        } else if (clazz == Integer.TYPE) {
            l = 0xFFFFFFFFL;
        } else {
            throw new IllegalArgumentException("Unrecognized unsigned array type " + clazz);
        }
        long[] lArray = new long[Array.getLength(object)];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Array.getLong(object, i) & l;
        }
        return lArray;
    }

    String encodeUnsignedArray(String string, Object object) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to encodeUnsignedArray: " + object.getClass());
        }
        long[] lArray = this.widenToUnsigned(object);
        return string + ":B:" + this.getArrayType(object, true) + "," + this.encodeArrayValue(lArray);
    }

    public String encodeUntypedTag(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(':');
        stringBuilder.append(object.toString());
        return stringBuilder.toString();
    }

    public Map.Entry<String, Object> decode(String string) {
        int n = StringUtil.splitConcatenateExcessTokens(string, this.fields, ':');
        if (n != 3) {
            throw new SAMFormatException("Not enough fields in tag '" + string + "'");
        }
        final String string2 = this.fields[0];
        String string3 = this.fields[1];
        String string4 = this.fields[2];
        final Object object = this.convertStringToObject(string3, string4);
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return string2;
            }

            @Override
            public Object getValue() {
                return object;
            }

            @Override
            public Object setValue(Object object2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Object convertStringToObject(String string, String string2) {
        if (string.equals("Z")) {
            return string2;
        }
        if (string.equals("A")) {
            if (string2.length() != 1) {
                throw new SAMFormatException("Tag of type A should have a single-character value");
            }
            return Character.valueOf(string2.charAt(0));
        }
        if (string.equals("i")) {
            long l;
            try {
                l = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAMFormatException("Tag of type i should have signed decimal value");
            }
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            if (SAMUtils.isValidUnsignedIntegerAttribute(l)) {
                return l;
            }
            throw new SAMFormatException("Integer is out of range for both a 32-bit signed and unsigned integer: " + string2);
        }
        if (string.equals("f")) {
            try {
                return new Float(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAMFormatException("Tag of type f should have single-precision floating point value");
            }
        }
        if (string.equals("H")) {
            try {
                return StringUtil.hexStringToBytes(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAMFormatException("Tag of type H should have valid hex string with even number of digits");
            }
        }
        if (string.equals("B")) {
            return this.covertStringArrayToObject(string2);
        }
        throw new SAMFormatException("Unrecognized tag type: " + string);
    }

    private Object covertStringArrayToObject(String string) {
        String[] stringArray = new String[2];
        if (StringUtil.splitConcatenateExcessTokens(string, stringArray, ',') != 2) {
            throw new SAMFormatException("Tag of type B should have an element type followed by comma");
        }
        if (stringArray[0].length() != 1) {
            throw new SAMFormatException("Unrecognized element type for array tag value: " + stringArray[0]);
        }
        char c = stringArray[0].charAt(0);
        String[] stringArray2 = stringArray[1].split(",");
        if (stringArray2.length == 0) {
            throw new SAMFormatException("Tag of type B should have at least one element");
        }
        if (c == 'f') {
            float[] fArray = new float[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                try {
                    fArray[i] = Float.parseFloat(stringArray2[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAMFormatException("Array tag of type f should have single-precision floating point value");
                }
            }
            return fArray;
        }
        long l = Long.MAX_VALUE;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        boolean bl = Character.isUpperCase(c);
        switch (Character.toLowerCase(c)) {
            case 'c': {
                if (bl) {
                    l = 255L;
                    break;
                }
                l2 = -128L;
                l3 = 127L;
                break;
            }
            case 's': {
                if (bl) {
                    l = 65535L;
                    break;
                }
                l2 = -32768L;
                l3 = 32767L;
                break;
            }
            case 'i': {
                if (bl) {
                    l = 0xFFFFFFFFL;
                    break;
                }
                l2 = Integer.MIN_VALUE;
                l3 = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized array tag element type: " + c);
            }
        }
        if (bl) {
            l2 = 0L;
            l3 = l;
        }
        long[] lArray = new long[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            long l4;
            try {
                l4 = Long.parseLong(stringArray2[i]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAMFormatException("Array tag of type " + c + " should have integral value");
            }
            if (l4 < l2 || l4 > l3) {
                throw new SAMFormatException("Value for element of array tag of type " + c + " is out of allowed range: " + l4);
            }
            lArray[i] = l4;
        }
        switch (Character.toLowerCase(c)) {
            case 'c': {
                byte[] byArray = new byte[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    byArray[i] = (byte)lArray[i];
                }
                if (bl) {
                    return new TagValueAndUnsignedArrayFlag(byArray, true);
                }
                return byArray;
            }
            case 's': {
                short[] sArray = new short[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    sArray[i] = (short)lArray[i];
                }
                if (bl) {
                    return new TagValueAndUnsignedArrayFlag(sArray, true);
                }
                return sArray;
            }
            case 'i': {
                int[] nArray = new int[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    nArray[i] = (int)lArray[i];
                }
                if (bl) {
                    return new TagValueAndUnsignedArrayFlag(nArray, true);
                }
                return nArray;
            }
        }
        throw new SAMFormatException("Unrecognized array tag element type: " + c);
    }

    Iso8601Date decodeDate(String string) {
        try {
            return new Iso8601Date(string);
        }
        catch (DateParser.InvalidDateException invalidDateException) {
            try {
                return new Iso8601Date(DateFormat.getDateTimeInstance().parse(string));
            }
            catch (ParseException parseException) {
                try {
                    return new Iso8601Date(new Date(string));
                }
                catch (Exception exception) {
                    throw new DateParser.InvalidDateException("Could not parse as date: " + string, parseException);
                }
            }
        }
    }
}

