/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.StreamInflatingIndexingOutputStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class BamFileIoUtils {
    private static final Log LOG = Log.getInstance(BamFileIoUtils.class);
    public static final String BAM_FILE_EXTENSION = ".bam";

    public static boolean isBamFile(File file) {
        return file != null && file.getName().endsWith(BAM_FILE_EXTENSION);
    }

    public static void reheaderBamFile(SAMFileHeader sAMFileHeader, File file, File file2) {
        BamFileIoUtils.reheaderBamFile(sAMFileHeader, file, file2, true, true);
    }

    public static void reheaderBamFile(SAMFileHeader sAMFileHeader, File file, File file2, boolean bl, boolean bl2) {
        IOUtil.assertFileIsReadable(file);
        IOUtil.assertFileIsWritable(file2);
        try {
            BlockCompressedInputStream.assertNonDefectiveFile(file);
            BamFileIoUtils.assertSortOrdersAreEqual(sAMFileHeader, file);
            OutputStream outputStream = BamFileIoUtils.buildOutputStream(file2, bl, bl2);
            BAMFileWriter.writeHeader(outputStream, sAMFileHeader);
            BamFileIoUtils.blockCopyBamFile(file, outputStream, true, false);
            CloserUtil.close(file);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public static void blockCopyBamFile(File file, OutputStream outputStream, boolean bl, boolean bl2) {
        FileInputStream fileInputStream = null;
        try {
            long l;
            fileInputStream = new FileInputStream(file);
            BlockCompressedInputStream.FileTermination fileTermination = BlockCompressedInputStream.checkTermination(file);
            if (fileTermination == BlockCompressedInputStream.FileTermination.DEFECTIVE) {
                throw new SAMException(file.getAbsolutePath() + " does not have a valid GZIP block at the end of the file.");
            }
            if (bl) {
                l = SAMUtils.findVirtualOffsetOfFirstRecordInBam(file);
                BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream(file);
                blockCompressedInputStream.seek(l);
                long l2 = blockCompressedInputStream.available();
                if (l2 >= 0L) {
                    BlockCompressedOutputStream blockCompressedOutputStream = new BlockCompressedOutputStream(outputStream, null);
                    IOUtil.transferByStream(blockCompressedInputStream, blockCompressedOutputStream, l2);
                    blockCompressedOutputStream.flush();
                }
                blockCompressedInputStream.close();
                for (long i = BlockCompressedFilePointerUtil.getBlockAddress(blockCompressedInputStream.getFilePointer()); i > 0L; i -= fileInputStream.skip(i)) {
                }
            }
            l = fileInputStream.getChannel().position();
            long l3 = file.length();
            long l4 = fileTermination == BlockCompressedInputStream.FileTermination.HAS_TERMINATOR_BLOCK && bl2 ? (long)BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length : 0L;
            long l5 = l3 - l4 - l;
            IOUtil.transferByStream(fileInputStream, outputStream, l5);
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeIOException(iOException);
            }
            catch (Throwable throwable) {
                CloserUtil.close(fileInputStream);
                throw throwable;
            }
        }
        CloserUtil.close(fileInputStream);
    }

    public static void gatherWithBlockCopying(List<File> list, File file, boolean bl, boolean bl2) {
        try {
            boolean bl3;
            OutputStream outputStream = new FileOutputStream(file);
            if (bl2) {
                outputStream = new Md5CalculatingOutputStream(outputStream, new File(file.getAbsolutePath() + ".md5"));
            }
            File file2 = null;
            if (bl) {
                file2 = new File(file.getParentFile(), IOUtil.basename(file) + ".bai");
                outputStream = new StreamInflatingIndexingOutputStream(outputStream, file2);
            }
            boolean bl4 = true;
            for (File file3 : list) {
                LOG.info(String.format("Block copying %s ...", file3.getAbsolutePath()));
                BamFileIoUtils.blockCopyBamFile(file3, outputStream, !bl4, true);
                bl4 = false;
            }
            ((OutputStream)outputStream).write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
            ((OutputStream)outputStream).close();
            if (bl && file.lastModified() > file2.lastModified() && !(bl3 = file2.setLastModified(System.currentTimeMillis()))) {
                System.err.print(String.format("Index file is older than BAM file for %s and unable to resolve this", file.getAbsolutePath()));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private static OutputStream buildOutputStream(File file, boolean bl, boolean bl2) throws IOException {
        OutputStream outputStream = new FileOutputStream(file);
        if (bl) {
            outputStream = new Md5CalculatingOutputStream(outputStream, new File(file.getAbsolutePath() + ".md5"));
        }
        if (bl2) {
            outputStream = new StreamInflatingIndexingOutputStream(outputStream, new File(file.getParentFile(), IOUtil.basename(file) + ".bai"));
        }
        return outputStream;
    }

    private static void assertSortOrdersAreEqual(SAMFileHeader sAMFileHeader, File file) throws IOException {
        SamReader samReader = SamReaderFactory.makeDefault().open(file);
        SAMFileHeader sAMFileHeader2 = samReader.getFileHeader();
        SAMFileHeader.SortOrder sortOrder = sAMFileHeader.getSortOrder();
        if (sortOrder != SAMFileHeader.SortOrder.unsorted && sortOrder != sAMFileHeader2.getSortOrder()) {
            throw new SAMException("Sort order of new header does not match the original file, needs to be " + (Object)((Object)sAMFileHeader2.getSortOrder()));
        }
        samReader.close();
    }
}

