/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteringIterator
implements CloseableIterator<SAMRecord> {
    private final PeekableIterator<SAMRecord> iterator;
    private final SamRecordFilter filter;
    private boolean filterReadPairs = false;
    private SAMRecord next = null;

    public FilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter samRecordFilter, boolean bl) {
        if (bl && iterator instanceof SAMRecordIterator) {
            ((SAMRecordIterator)iterator).assertSorted(SAMFileHeader.SortOrder.queryname);
        }
        this.iterator = new PeekableIterator<SAMRecord>(iterator);
        this.filter = samRecordFilter;
        this.filterReadPairs = bl;
        this.next = this.getNextRecord();
    }

    public FilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter samRecordFilter) {
        this.iterator = new PeekableIterator<SAMRecord>(iterator);
        this.filter = samRecordFilter;
        this.next = this.getNextRecord();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public SAMRecord next() {
        if (this.next == null) {
            throw new NoSuchElementException("Iterator has no more elements.");
        }
        SAMRecord sAMRecord = this.next;
        this.next = this.getNextRecord();
        return sAMRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported by FilteringIterator");
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
    }

    private SAMRecord getNextRecord() {
        while (this.iterator.hasNext()) {
            SAMRecord sAMRecord = this.iterator.next();
            if (this.filterReadPairs && sAMRecord.getReadPairedFlag() && sAMRecord.getFirstOfPairFlag() && this.iterator.hasNext()) {
                SamPairUtil.assertMate(sAMRecord, this.iterator.peek());
                if (this.filter.filterOut(sAMRecord, this.iterator.peek())) {
                    this.iterator.next();
                    continue;
                }
                return sAMRecord;
            }
            if (this.filterReadPairs && sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag()) {
                return sAMRecord;
            }
            if (this.filter.filterOut(sAMRecord)) continue;
            return sAMRecord;
        }
        return null;
    }
}

