/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.ExternalCompressor;
import htsjdk.samtools.cram.encoding.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.encoding.SubexponentialIntegerEncoding;
import htsjdk.samtools.cram.encoding.huffman.HuffmanCode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.rans.RANS;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class CompressionHeaderFactory {
    private static final Charset charset = Charset.forName("US-ASCII");
    private static final Log log = Log.getInstance(CompressionHeaderFactory.class);
    private static final int oqz = ReadTag.nameType3BytesToInt("OQ", 'Z');
    private static final int bqz = ReadTag.nameType3BytesToInt("BQ", 'Z');

    /*
     * WARNING - void declaration
     */
    public CompressionHeader build(List<CramCompressionRecord> list, SubstitutionMatrix substitutionMatrix, boolean bl) {
        void cramCompressionRecord;
        CompressionHeader compressionHeader = new CompressionHeader();
        compressionHeader.externalIds = new ArrayList<Integer>();
        int n = 0;
        int n2 = n++;
        compressionHeader.externalIds.add(n2);
        compressionHeader.externalCompressors.put(n2, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        int n3 = n++;
        compressionHeader.externalIds.add(n3);
        compressionHeader.externalCompressors.put(n3, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        int n4 = n++;
        compressionHeader.externalIds.add(n4);
        compressionHeader.externalCompressors.put(n4, ExternalCompressor.createGZIP());
        int n5 = n++;
        compressionHeader.externalIds.add(n5);
        compressionHeader.externalCompressors.put(n5, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        compressionHeader.encodingMap = new TreeMap<EncodingKey, EncodingParams>();
        Object object3 = EncodingKey.values();
        int n6 = ((EncodingKey[])object3).length;
        boolean bl2 = false;
        while (cramCompressionRecord < n6) {
            EncodingKey encodingKey = object3[cramCompressionRecord];
            compressionHeader.encodingMap.put(encodingKey, NullEncoding.toParam());
            ++cramCompressionRecord;
        }
        compressionHeader.tMap = new TreeMap<Integer, EncodingParams>();
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.BF_BitFlags, 0, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.CF_CompressionBitFlags, 0, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.RI_RefId, -2, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.RL_ReadLength, 0, list);
        if (bl) {
            compressionHeader.APDelta = true;
            CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.AP_AlignmentPositionOffset, 0, list);
        } else {
            int n62 = n++;
            compressionHeader.APDelta = false;
            compressionHeader.encodingMap.put(EncodingKey.AP_AlignmentPositionOffset, ExternalIntegerEncoding.toParam(n62));
            compressionHeader.externalIds.add(n62);
            compressionHeader.externalCompressors.put(n62, ExternalCompressor.createRANS(RANS.ORDER.ONE));
            log.debug("Assigned external id to alignment starts: " + n62);
        }
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.RG_ReadGroup, -1, list);
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord2 : list) {
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord2.readName.length());
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.encodingMap.put(EncodingKey.RN_ReadName, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()), ExternalByteArrayEncoding.toParam(n4)));
        object3 = new IntegerEncodingCalculator(EncodingKey.NF_RecordsToNextFragment.name(), 0);
        for (CramCompressionRecord cramCompressionRecord3 : list) {
            if (!cramCompressionRecord3.isHasMateDownStream()) continue;
            ((IntegerEncodingCalculator)object3).addValue(cramCompressionRecord3.recordsToNextFragment);
        }
        Iterator<CramCompressionRecord> iterator = ((IntegerEncodingCalculator)object3).getBestEncoding();
        compressionHeader.encodingMap.put(EncodingKey.NF_RecordsToNextFragment, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord4 : list) {
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord4.tags == null ? 0 : cramCompressionRecord4.tags.length);
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.encodingMap.put(EncodingKey.TC_TagCount, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord object42 : list) {
            if (object42.tags == null) continue;
            for (ReadTag readTag : object42.tags) {
                ((HuffmanParamsCalculator)object3).add(readTag.keyType3BytesAsInt);
            }
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.encodingMap.put(EncodingKey.TN_TagNameAndType, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()));
        object3 = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag readTag, ReadTag readTag2) {
                return readTag.keyType3BytesAsInt - readTag2.keyType3BytesAsInt;
            }
        };
        iterator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                if (byArray.length - byArray2.length != 0) {
                    return byArray.length - byArray2.length;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return byArray[i] - byArray2[i];
                }
                return 0;
            }
        };
        TreeMap<byte[], MutableInt> treeMap = new TreeMap<byte[], MutableInt>((Comparator<byte[]>)((Object)iterator));
        MutableInt mutableInt = new MutableInt();
        treeMap.put(new byte[0], mutableInt);
        for (CramCompressionRecord cramCompressionRecord5 : list) {
            void var17_89;
            void var17_91;
            if (cramCompressionRecord5.tags == null) {
                ++mutableInt.value;
                cramCompressionRecord5.tagIdsIndex = mutableInt;
                continue;
            }
            Arrays.sort(cramCompressionRecord5.tags, object3);
            cramCompressionRecord5.tagIds = new byte[cramCompressionRecord5.tags.length * 3];
            int n7 = 0;
            boolean bl3 = false;
            while (var17_91 < cramCompressionRecord5.tags.length) {
                cramCompressionRecord5.tagIds[var17_91 * 3] = (byte)cramCompressionRecord5.tags[n7].keyType3Bytes.charAt(0);
                cramCompressionRecord5.tagIds[var17_91 * 3 + true] = (byte)cramCompressionRecord5.tags[n7].keyType3Bytes.charAt(1);
                cramCompressionRecord5.tagIds[var17_91 * 3 + 2] = (byte)cramCompressionRecord5.tags[n7].keyType3Bytes.charAt(2);
                ++n7;
                ++var17_91;
            }
            MutableInt mutableInt2 = (MutableInt)treeMap.get(cramCompressionRecord5.tagIds);
            if (mutableInt2 == null) {
                MutableInt mutableInt3 = new MutableInt();
                treeMap.put(cramCompressionRecord5.tagIds, mutableInt3);
            }
            ++var17_89.value;
            cramCompressionRecord5.tagIdsIndex = var17_89;
        }
        ReadTag[] readTagArray = (ReadTag[])new byte[treeMap.size()][][];
        int n8 = 0;
        HuffmanParamsCalculator huffmanParamsCalculator = new HuffmanParamsCalculator();
        for (byte[] byArray : treeMap.keySet()) {
            int n9 = byArray.length / 3;
            readTagArray[n8] = new byte[n9][];
            int n10 = 0;
            while (n10 < byArray.length) {
                int n11 = n10 / 3;
                readTagArray[n8][n11] = new byte[3];
                readTagArray[n8][n11][0] = byArray[n10++];
                readTagArray[n8][n11][1] = byArray[n10++];
                readTagArray[n8][n11][2] = (ReadTag)byArray[n10++];
            }
            huffmanParamsCalculator.add(n8, ((MutableInt)treeMap.get((Object)byArray)).value);
            ((MutableInt)treeMap.get((Object)byArray)).value = n8++;
        }
        huffmanParamsCalculator.calculate();
        compressionHeader.encodingMap.put(EncodingKey.TL_TagIdList, HuffmanIntegerEncoding.toParam(huffmanParamsCalculator.values(), huffmanParamsCalculator.bitLens()));
        compressionHeader.dictionary = (byte[][][])readTagArray;
        int n12 = n;
        compressionHeader.externalIds.add(n12);
        compressionHeader.externalCompressors.put(n12, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        iterator = new HashSet();
        for (CramCompressionRecord cramCompressionRecord6 : list) {
            if (cramCompressionRecord6.tags == null) continue;
            for (ReadTag readTag : cramCompressionRecord6.tags) {
                iterator.add((CramCompressionRecord)((Object)Integer.valueOf(readTag.keyType3BytesAsInt)));
            }
        }
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            int n13;
            int n14 = (Integer)iterator2.next();
            n8 = (byte)(n14 & 0xFF);
            switch (n8) {
                case 66: 
                case 90: {
                    n13 = n14;
                    break;
                }
                default: {
                    n13 = n12;
                }
            }
            compressionHeader.externalIds.add(n13);
            compressionHeader.externalCompressors.put(n13, ExternalCompressor.createRANS(RANS.ORDER.ONE));
            compressionHeader.tMap.put(n14, ByteArrayLenEncoding.toParam(ExternalIntegerEncoding.toParam(n13), ExternalByteEncoding.toParam(n13)));
        }
        Object object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord7 : list) {
            ((HuffmanParamsCalculator)object6).add(cramCompressionRecord7.readFeatures == null ? 0 : cramCompressionRecord7.readFeatures.size());
        }
        ((HuffmanParamsCalculator)object6).calculate();
        compressionHeader.encodingMap.put(EncodingKey.FN_NumberOfReadFeatures, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object6).values(), ((HuffmanParamsCalculator)object6).bitLens()));
        object6 = new IntegerEncodingCalculator("read feature position", 0);
        for (CramCompressionRecord cramCompressionRecord8 : list) {
            boolean bl4 = false;
            if (cramCompressionRecord8.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord8.readFeatures) {
                int n15;
                ((IntegerEncodingCalculator)object6).addValue(readFeature.getPosition() - n15);
                n15 = readFeature.getPosition();
            }
        }
        iterator = ((IntegerEncodingCalculator)object6).getBestEncoding();
        compressionHeader.encodingMap.put(EncodingKey.FP_FeaturePosition, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord9 : list) {
            if (cramCompressionRecord9.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord9.readFeatures) {
                ((HuffmanParamsCalculator)object6).add(readFeature.getOperator());
            }
        }
        ((HuffmanParamsCalculator)object6).calculate();
        compressionHeader.encodingMap.put(EncodingKey.FC_FeatureCode, HuffmanByteEncoding.toParam(((HuffmanParamsCalculator)object6).valuesAsBytes(), ((HuffmanParamsCalculator)object6).bitLens));
        compressionHeader.encodingMap.put(EncodingKey.BA_Base, ExternalByteEncoding.toParam(n2));
        compressionHeader.encodingMap.put(EncodingKey.QS_QualityScore, ExternalByteEncoding.toParam(n3));
        if (substitutionMatrix == null) {
            object6 = new long[200][200];
            for (CramCompressionRecord cramCompressionRecord10 : list) {
                if (cramCompressionRecord10.readFeatures == null) continue;
                for (ReadFeature readFeature : cramCompressionRecord10.readFeatures) {
                    if (readFeature.getOperator() != 88) continue;
                    Substitution substitution = (Substitution)readFeature;
                    byte by = substitution.getReferenceBase();
                    byte by2 = substitution.getBase();
                    Object object = object6[by];
                    byte by3 = by2;
                    object[by3] = object[by3] + 1L;
                }
            }
            compressionHeader.substitutionMatrix = new SubstitutionMatrix((long[][])object6);
        } else {
            compressionHeader.substitutionMatrix = substitutionMatrix;
        }
        object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord11 : list) {
            if (cramCompressionRecord11.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord11.readFeatures) {
                if (readFeature.getOperator() != 88) continue;
                Substitution substitution = (Substitution)readFeature;
                if (substitution.getCode() == -1) {
                    byte by = substitution.getReferenceBase();
                    byte by4 = substitution.getBase();
                    substitution.setCode(compressionHeader.substitutionMatrix.code(by, by4));
                }
                ((HuffmanParamsCalculator)object6).add(substitution.getCode());
            }
        }
        ((HuffmanParamsCalculator)object6).calculate();
        compressionHeader.encodingMap.put(EncodingKey.BS_BaseSubstitutionCode, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object6).values, ((HuffmanParamsCalculator)object6).bitLens));
        compressionHeader.encodingMap.put(EncodingKey.IN_Insertion, ByteArrayStopEncoding.toParam((byte)0, n2));
        compressionHeader.encodingMap.put(EncodingKey.SC_SoftClip, ByteArrayStopEncoding.toParam((byte)0, n2));
        object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord12 : list) {
            if (cramCompressionRecord12.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord12.readFeatures) {
                if (readFeature.getOperator() != 68) continue;
                ((HuffmanParamsCalculator)object6).add(((Deletion)readFeature).getLength());
            }
        }
        ((HuffmanParamsCalculator)object6).calculate();
        compressionHeader.encodingMap.put(EncodingKey.DL_DeletionLength, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object6).values, ((HuffmanParamsCalculator)object6).bitLens));
        object6 = new IntegerEncodingCalculator(EncodingKey.HC_HardClip.name(), 0);
        for (CramCompressionRecord cramCompressionRecord13 : list) {
            if (cramCompressionRecord13.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord13.readFeatures) {
                if (readFeature.getOperator() != 72) continue;
                ((IntegerEncodingCalculator)object6).addValue(((HardClip)readFeature).getLength());
            }
        }
        iterator = ((IntegerEncodingCalculator)object6).getBestEncoding();
        compressionHeader.encodingMap.put(EncodingKey.HC_HardClip, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object6 = new IntegerEncodingCalculator(EncodingKey.PD_padding.name(), 0);
        for (CramCompressionRecord cramCompressionRecord14 : list) {
            if (cramCompressionRecord14.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord14.readFeatures) {
                if (readFeature.getOperator() != 80) continue;
                ((IntegerEncodingCalculator)object6).addValue(((Padding)readFeature).getLength());
            }
        }
        iterator = ((IntegerEncodingCalculator)object6).getBestEncoding();
        compressionHeader.encodingMap.put(EncodingKey.PD_padding, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord15 : list) {
            if (cramCompressionRecord15.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord15.readFeatures) {
                if (readFeature.getOperator() != 78) continue;
                ((HuffmanParamsCalculator)object6).add(((RefSkip)readFeature).getLength());
            }
        }
        ((HuffmanParamsCalculator)object6).calculate();
        compressionHeader.encodingMap.put(EncodingKey.RS_RefSkip, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object6).values, ((HuffmanParamsCalculator)object6).bitLens));
        object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord16 : list) {
            if (cramCompressionRecord16.isSegmentUnmapped()) continue;
            ((HuffmanParamsCalculator)object6).add(cramCompressionRecord16.mappingQuality);
        }
        ((HuffmanParamsCalculator)object6).calculate();
        compressionHeader.encodingMap.put(EncodingKey.MQ_MappingQualityScore, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object6).values(), ((HuffmanParamsCalculator)object6).bitLens));
        object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord17 : list) {
            ((HuffmanParamsCalculator)object6).add(cramCompressionRecord17.getMateFlags());
        }
        ((HuffmanParamsCalculator)object6).calculate();
        compressionHeader.encodingMap.put(EncodingKey.MF_MateBitFlags, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object6).values, ((HuffmanParamsCalculator)object6).bitLens));
        object6 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord18 : list) {
            if (!cramCompressionRecord18.isDetached()) continue;
            ((HuffmanParamsCalculator)object6).add(cramCompressionRecord18.mateSequenceID);
        }
        ((HuffmanParamsCalculator)object6).calculate();
        if (((HuffmanParamsCalculator)object6).values.length == 0) {
            compressionHeader.encodingMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, NullEncoding.toParam());
        }
        compressionHeader.encodingMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object6).values(), ((HuffmanParamsCalculator)object6).bitLens()));
        log.debug("NS: " + compressionHeader.encodingMap.get((Object)EncodingKey.NS_NextFragmentReferenceSequenceID));
        compressionHeader.encodingMap.put(EncodingKey.NP_NextFragmentAlignmentStart, ExternalIntegerEncoding.toParam(n5));
        compressionHeader.encodingMap.put(EncodingKey.TS_InsetSize, ExternalIntegerEncoding.toParam(n5));
        return compressionHeader;
    }

    private static int getValue(EncodingKey encodingKey, CramCompressionRecord cramCompressionRecord) {
        switch (encodingKey) {
            case AP_AlignmentPositionOffset: {
                return cramCompressionRecord.alignmentDelta;
            }
            case BF_BitFlags: {
                return cramCompressionRecord.flags;
            }
            case CF_CompressionBitFlags: {
                return cramCompressionRecord.compressionFlags;
            }
            case FN_NumberOfReadFeatures: {
                return cramCompressionRecord.readFeatures == null ? 0 : cramCompressionRecord.readFeatures.size();
            }
            case MF_MateBitFlags: {
                return cramCompressionRecord.mateFlags;
            }
            case MQ_MappingQualityScore: {
                return cramCompressionRecord.mappingQuality;
            }
            case NF_RecordsToNextFragment: {
                return cramCompressionRecord.recordsToNextFragment;
            }
            case NP_NextFragmentAlignmentStart: {
                return cramCompressionRecord.mateAlignmentStart;
            }
            case NS_NextFragmentReferenceSequenceID: {
                return cramCompressionRecord.mateSequenceID;
            }
            case RG_ReadGroup: {
                return cramCompressionRecord.readGroupID;
            }
            case RI_RefId: {
                return cramCompressionRecord.sequenceId;
            }
            case RL_ReadLength: {
                return cramCompressionRecord.readLength;
            }
            case TC_TagCount: {
                return cramCompressionRecord.tags == null ? 0 : cramCompressionRecord.tags.length;
            }
        }
        throw new RuntimeException("Unexpected encoding key: " + encodingKey.name());
    }

    private static void getOptimalIntegerEncoding(CompressionHeader compressionHeader, EncodingKey encodingKey, int n, List<CramCompressionRecord> list) {
        IntegerEncodingCalculator integerEncodingCalculator = new IntegerEncodingCalculator(encodingKey.name(), n);
        for (CramCompressionRecord cramCompressionRecord : list) {
            int n2 = CompressionHeaderFactory.getValue(encodingKey, cramCompressionRecord);
            integerEncodingCalculator.addValue(n2);
        }
        Encoding<Integer> encoding = integerEncodingCalculator.getBestEncoding();
        compressionHeader.encodingMap.put(encodingKey, new EncodingParams(encoding.id(), encoding.toByteArray()));
    }

    private static Integer[] autobox(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static class IntegerEncodingCalculator {
        public final List<EncodingLengthCalculator> calculators = new ArrayList<EncodingLengthCalculator>();
        private int max = 0;
        private int count = 0;
        private final String name;
        private HashMap<Integer, MutableInt> dictionary = new HashMap();
        private final int dictionaryThreshold = 100;
        private final int minValue;

        public IntegerEncodingCalculator(String string, int n, int n2) {
            this.name = string;
            this.minValue = n2;
            this.calculators.add(new EncodingLengthCalculator(new GammaIntegerEncoding(1 - n2)));
            for (int i = 2; i < 5; ++i) {
                this.calculators.add(new EncodingLengthCalculator(new SubexponentialIntegerEncoding(0 - n2, i)));
            }
            this.dictionary = n < 1 ? null : new HashMap();
        }

        public IntegerEncodingCalculator(String string, int n) {
            this(string, 255, n);
        }

        public void addValue(int n) {
            ++this.count;
            if (n > this.max) {
                this.max = n;
            }
            for (EncodingLengthCalculator encodingLengthCalculator : this.calculators) {
                encodingLengthCalculator.add(n);
            }
            if (this.dictionary != null) {
                if (this.dictionary.size() >= 99) {
                    this.dictionary = null;
                } else {
                    Object object = this.dictionary.get(n);
                    if (object == null) {
                        object = new MutableInt();
                        this.dictionary.put(n, (MutableInt)object);
                    }
                    ++((MutableInt)object).value;
                }
            }
        }

        public Encoding<Integer> getBestEncoding() {
            int n;
            if (this.dictionary != null && this.dictionary.size() == 1) {
                int n2 = this.dictionary.keySet().iterator().next();
                EncodingParams encodingParams = HuffmanIntegerEncoding.toParam(new int[]{n2}, new int[]{0});
                HuffmanIntegerEncoding huffmanIntegerEncoding = new HuffmanIntegerEncoding();
                huffmanIntegerEncoding.fromByteArray(encodingParams.params);
                return huffmanIntegerEncoding;
            }
            EncodingLengthCalculator encodingLengthCalculator = this.calculators.get(0);
            for (EncodingLengthCalculator encodingLengthCalculator2 : this.calculators) {
                if (encodingLengthCalculator2.length() >= encodingLengthCalculator.length()) continue;
                encodingLengthCalculator = encodingLengthCalculator2;
            }
            Object object = encodingLengthCalculator.encoding;
            long l = encodingLengthCalculator.length();
            if (l > (long)((n = (int)Math.round(Math.log(this.max - this.minValue) / Math.log(2.0) + 0.5)) * this.count)) {
                object = new BetaIntegerEncoding(-this.minValue, n);
                l = n * this.count;
            }
            if (this.dictionary != null) {
                HuffmanParamsCalculator huffmanParamsCalculator = new HuffmanParamsCalculator();
                for (Integer object22 : this.dictionary.keySet()) {
                    huffmanParamsCalculator.add(object22, this.dictionary.get((Object)object22).value);
                }
                huffmanParamsCalculator.calculate();
                EncodingParams encodingParams = HuffmanIntegerEncoding.toParam(huffmanParamsCalculator.values(), huffmanParamsCalculator.bitLens());
                HuffmanIntegerEncoding huffmanIntegerEncoding = new HuffmanIntegerEncoding();
                huffmanIntegerEncoding.fromByteArray(encodingParams.params);
                EncodingLengthCalculator encodingLengthCalculator2 = new EncodingLengthCalculator(huffmanIntegerEncoding);
                for (Integer n2 : this.dictionary.keySet()) {
                    encodingLengthCalculator2.add(n2, this.dictionary.get((Object)n2).value);
                }
                if (encodingLengthCalculator2.length() < l) {
                    object = huffmanIntegerEncoding;
                    l = encodingLengthCalculator2.length();
                }
            }
            byte[] byArray = object.toByteArray();
            byArray = Arrays.copyOf(byArray, Math.min(byArray.length, 20));
            log.debug("Best encoding for " + this.name + ": " + object.id().name() + Arrays.toString(byArray) + ", bits=" + l);
            return object;
        }
    }

    public static class EncodingLengthCalculator {
        private final BitCodec<Integer> codec;
        private final Encoding<Integer> encoding;
        private long length;

        public EncodingLengthCalculator(Encoding<Integer> encoding) {
            this.encoding = encoding;
            this.codec = encoding.buildCodec(null, null);
        }

        public void add(int n) {
            this.length += this.codec.numberOfBits(n);
        }

        public void add(int n, int n2) {
            this.length += (long)n2 * this.codec.numberOfBits(n);
        }

        public long length() {
            return this.length;
        }
    }

    public static class HuffmanParamsCalculator {
        private final HashMap<Integer, MutableInt> countMap = new HashMap();
        private int[] values = new int[0];
        private int[] bitLens = new int[0];

        public void add(int n) {
            MutableInt mutableInt = this.countMap.get(n);
            if (mutableInt == null) {
                mutableInt = new MutableInt();
                this.countMap.put(n, mutableInt);
            }
            ++mutableInt.value;
        }

        public void add(Integer n, int n2) {
            MutableInt mutableInt = this.countMap.get(n);
            if (mutableInt == null) {
                mutableInt = new MutableInt();
                this.countMap.put(n, mutableInt);
            }
            mutableInt.value += n2;
        }

        public int[] bitLens() {
            return this.bitLens;
        }

        public int[] values() {
            return this.values;
        }

        public Integer[] valuesAsAutoIntegers() {
            Integer[] integerArray = new Integer[this.values.length];
            for (int i = 0; i < integerArray.length; ++i) {
                integerArray[i] = this.values[i];
            }
            return integerArray;
        }

        public byte[] valuesAsBytes() {
            byte[] byArray = new byte[this.values.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(0xFF & this.values[i]);
            }
            return byArray;
        }

        public Byte[] valuesAsAutoBytes() {
            Byte[] byteArray = new Byte[this.values.length];
            for (int i = 0; i < byteArray.length; ++i) {
                byteArray[i] = (byte)(0xFF & this.values[i]);
            }
            return byteArray;
        }

        public void calculate() {
            int n = this.countMap.size();
            Object object = new int[n];
            Object[] objectArray = new int[n];
            int n2 = 0;
            for (Integer n3 : this.countMap.keySet()) {
                objectArray[n2] = n3;
                object[n2] = this.countMap.get((Object)n3).value;
                ++n2;
            }
            HuffmanTree<Integer> huffmanTree = HuffmanCode.buildTree((int[])object, CompressionHeaderFactory.autobox(objectArray));
            ArrayList arrayList = new ArrayList();
            object = new ArrayList();
            HuffmanCode.getValuesAndBitLengths(arrayList, (List<Integer>)object, huffmanTree);
            objectArray = new BitCode[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                objectArray[n2] = (int)new BitCode((Integer)arrayList.get(n2), (Integer)object.get(n2));
            }
            Arrays.sort(objectArray);
            this.values = new int[objectArray.length];
            this.bitLens = new int[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object2 = objectArray[n2];
                this.bitLens[n2] = ((BitCode)object2).length;
                this.values[n2] = ((BitCode)object2).value;
            }
        }
    }

    private static class BitCode
    implements Comparable<BitCode> {
        final int value;
        final int length;

        public BitCode(int n, int n2) {
            this.value = n;
            this.length = n2;
        }

        @Override
        public int compareTo(BitCode bitCode) {
            int n = this.value - bitCode.value;
            if (n != 0) {
                return n;
            }
            return this.length - bitCode.length;
        }
    }
}

