/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.Slice;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CRAIEntry
implements Comparable<CRAIEntry>,
Cloneable {
    public int sequenceId;
    public int alignmentStart;
    public int alignmentSpan;
    public long containerStartOffset;
    public int sliceOffset;
    public int sliceSize;
    public int sliceIndex;
    public static Comparator<CRAIEntry> byEnd = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry cRAIEntry, CRAIEntry cRAIEntry2) {
            if (cRAIEntry.sequenceId != cRAIEntry2.sequenceId) {
                return cRAIEntry2.sequenceId - cRAIEntry.sequenceId;
            }
            if (cRAIEntry.alignmentStart + cRAIEntry.alignmentSpan != cRAIEntry2.alignmentStart + cRAIEntry2.alignmentSpan) {
                return cRAIEntry.alignmentStart + cRAIEntry.alignmentSpan - cRAIEntry2.alignmentStart - cRAIEntry2.alignmentSpan;
            }
            return (int)(cRAIEntry.containerStartOffset - cRAIEntry2.containerStartOffset);
        }
    };
    public static final Comparator<CRAIEntry> byStart = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry cRAIEntry, CRAIEntry cRAIEntry2) {
            if (cRAIEntry.sequenceId != cRAIEntry2.sequenceId) {
                return cRAIEntry2.sequenceId - cRAIEntry.sequenceId;
            }
            if (cRAIEntry.alignmentStart != cRAIEntry2.alignmentStart) {
                return cRAIEntry.alignmentStart - cRAIEntry2.alignmentStart;
            }
            return (int)(cRAIEntry.containerStartOffset - cRAIEntry2.containerStartOffset);
        }
    };

    public CRAIEntry() {
    }

    public static List<CRAIEntry> fromContainer(Container container) {
        ArrayList<CRAIEntry> arrayList = new ArrayList<CRAIEntry>(container.slices.length);
        int n = 0;
        while (n < container.slices.length) {
            Slice slice = container.slices[n];
            CRAIEntry cRAIEntry = new CRAIEntry();
            cRAIEntry.sequenceId = slice.sequenceId;
            cRAIEntry.alignmentStart = slice.alignmentStart;
            cRAIEntry.alignmentSpan = slice.alignmentSpan;
            cRAIEntry.containerStartOffset = slice.containerOffset;
            cRAIEntry.sliceOffset = container.landmarks[n];
            cRAIEntry.sliceSize = slice.size;
            cRAIEntry.sliceIndex = n++;
            arrayList.add(cRAIEntry);
        }
        return arrayList;
    }

    public static CRAIEntry fromCraiLine(String string) {
        return new CRAIEntry(string);
    }

    public CRAIEntry(String string) throws CRAIIndex.CRAIIndexException {
        String[] stringArray = string.split("\t");
        if (stringArray.length != 6) {
            throw new CRAIIndex.CRAIIndexException("Expecting 6 columns but got " + stringArray.length);
        }
        try {
            this.sequenceId = Integer.parseInt(stringArray[0]);
            this.alignmentStart = Integer.parseInt(stringArray[1]);
            this.alignmentSpan = Integer.parseInt(stringArray[2]);
            this.containerStartOffset = Long.parseLong(stringArray[3]);
            this.sliceOffset = Integer.parseInt(stringArray[4]);
            this.sliceSize = Integer.parseInt(stringArray[5]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CRAIIndex.CRAIIndexException(numberFormatException);
        }
    }

    public String toString() {
        return String.format("%d\t%d\t%d\t%d\t%d\t%d", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerStartOffset, this.sliceOffset, this.sliceSize);
    }

    @Override
    public int compareTo(CRAIEntry cRAIEntry) {
        if (cRAIEntry == null) {
            return 1;
        }
        if (this.sequenceId != cRAIEntry.sequenceId) {
            return this.sequenceId - cRAIEntry.sequenceId;
        }
        if (this.alignmentStart != cRAIEntry.alignmentStart) {
            return this.alignmentStart - cRAIEntry.alignmentStart;
        }
        return (int)(this.containerStartOffset - cRAIEntry.containerStartOffset);
    }

    public CRAIEntry clone() throws CloneNotSupportedException {
        super.clone();
        CRAIEntry cRAIEntry = new CRAIEntry();
        cRAIEntry.sequenceId = this.sequenceId;
        cRAIEntry.alignmentStart = this.alignmentStart;
        cRAIEntry.alignmentSpan = this.alignmentSpan;
        cRAIEntry.containerStartOffset = this.containerStartOffset;
        cRAIEntry.sliceOffset = this.sliceOffset;
        cRAIEntry.sliceSize = this.sliceSize;
        return cRAIEntry;
    }

    public static boolean intersect(CRAIEntry cRAIEntry, CRAIEntry cRAIEntry2) {
        if (cRAIEntry.sequenceId != cRAIEntry2.sequenceId) {
            return false;
        }
        if (cRAIEntry.sequenceId < 0) {
            return false;
        }
        int n = cRAIEntry.alignmentStart;
        int n2 = n + cRAIEntry.alignmentSpan;
        int n3 = cRAIEntry2.alignmentStart;
        int n4 = n3 + cRAIEntry2.alignmentSpan;
        return Math.abs(n + n2 - n3 - n4) < cRAIEntry.alignmentSpan + cRAIEntry2.alignmentSpan;
    }
}

