/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.util.HashSet;
import java.util.Set;

public enum SAMFlag {
    READ_PAIRED(1, "Template having multiple segments in sequencing"),
    PROPER_PAIR(2, "Each segment properly aligned according to the aligner"),
    READ_UNMAPPED(4, "Segment unmapped"),
    MATE_UNMAPPED(8, "Next segment in the template unmapped"),
    READ_REVERSE_STRAND(16, "SEQ being reverse complemented"),
    MATE_REVERSE_STRAND(32, "SEQ of the next segment in the template being reverse complemented"),
    FIRST_OF_PAIR(64, "The first segment in the template"),
    SECOND_OF_PAIR(128, "The last segment in the template"),
    NOT_PRIMARY_ALIGNMENT(256, "Secondary alignment"),
    READ_FAILS_VENDOR_QUALITY_CHECK(512, "Not passing quality controls"),
    DUPLICATE_READ(1024, "PCR or optical duplicate"),
    SUPPLEMENTARY_ALIGNMENT(2048, "Supplementary alignment");

    final int flag;
    private final String description;

    private SAMFlag(int n2, String string2) {
        this.flag = n2;
        this.description = string2;
    }

    public int intValue() {
        return this.flag;
    }

    public String getLabel() {
        return this.name().toLowerCase().replace('_', ' ');
    }

    public String getDescription() {
        return this.description;
    }

    public static SAMFlag valueOf(int n) {
        for (SAMFlag sAMFlag : SAMFlag.values()) {
            if (n != sAMFlag.flag) continue;
            return sAMFlag;
        }
        return null;
    }

    public static SAMFlag findByName(String string) {
        for (SAMFlag sAMFlag : SAMFlag.values()) {
            if (!sAMFlag.name().equals(string)) continue;
            return sAMFlag;
        }
        return null;
    }

    public boolean isSet(int n) {
        return (this.flag & n) != 0;
    }

    public boolean isUnset(int n) {
        return !this.isSet(n);
    }

    public static Set<SAMFlag> getFlags(int n) {
        HashSet<SAMFlag> hashSet = new HashSet<SAMFlag>();
        for (SAMFlag sAMFlag : SAMFlag.values()) {
            if (!sAMFlag.isSet(n)) continue;
            hashSet.add(sAMFlag);
        }
        return hashSet;
    }
}

