/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.BinaryCodec;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class BinaryBAMIndexWriter
implements BAMIndexWriter {
    protected final int nRef;
    private final BinaryCodec codec;
    private int count = 0;

    public BinaryBAMIndexWriter(int n, File file) {
        this.nRef = n;
        try {
            this.codec = new BinaryCodec(file, true);
            this.writeHeader();
        }
        catch (Exception exception) {
            throw new SAMException("Exception opening output file " + file, exception);
        }
    }

    public BinaryBAMIndexWriter(int n, OutputStream outputStream) {
        this.nRef = n;
        try {
            this.codec = new BinaryCodec(outputStream);
            this.writeHeader();
        }
        catch (Exception exception) {
            throw new SAMException("Exception opening output stream", exception);
        }
    }

    @Override
    public void writeReference(BAMIndexContent bAMIndexContent) {
        int n;
        Object object;
        int n2;
        if (bAMIndexContent == null) {
            this.writeNullContent();
            ++this.count;
            return;
        }
        if (bAMIndexContent.getReferenceSequence() != this.count) {
            throw new SAMException("Unexpectedly writing reference " + bAMIndexContent.getReferenceSequence() + ", expecting reference " + this.count);
        }
        ++this.count;
        BinningIndexContent.BinList binList = bAMIndexContent.getBins();
        int n3 = n2 = binList == null ? 0 : bAMIndexContent.getNumberOfNonNullBins();
        if (n2 == 0) {
            this.writeNullContent();
            return;
        }
        BAMIndexMetaData bAMIndexMetaData = bAMIndexContent.getMetaData();
        this.codec.writeInt(n2 + (bAMIndexMetaData != null ? 1 : 0));
        Object object2 = binList.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((Bin)object).getBinNumber() == 37450) continue;
            this.writeBin((Bin)object);
        }
        if (bAMIndexMetaData != null) {
            this.writeChunkMetaData(bAMIndexMetaData);
        }
        object = (object2 = bAMIndexContent.getLinearIndex()) == null ? null : ((LinearIndex)object2).getIndexEntries();
        int n4 = object2 == null ? 0 : ((LinearIndex)object2).getIndexStart();
        int n5 = object == null ? n4 : ((Object)object).length + n4;
        this.codec.writeInt(n5);
        if (object == null) {
            return;
        }
        for (n = 0; n < n4; ++n) {
            this.codec.writeLong(0L);
        }
        for (n = 0; n < ((Object)object).length; ++n) {
            this.codec.writeLong((long)object[n]);
        }
        try {
            this.codec.getOutputStream().flush();
        }
        catch (IOException iOException) {
            throw new SAMException("IOException in BinaryBAMIndexWriter reference " + bAMIndexContent.getReferenceSequence(), iOException);
        }
    }

    @Override
    public void writeNoCoordinateRecordCount(Long l) {
        this.codec.writeLong(l == null ? 0L : l);
    }

    @Override
    public void close() {
        this.codec.close();
    }

    private void writeBin(Bin bin) {
        int n = bin.getBinNumber();
        if (n >= 37450) {
            throw new SAMException("Unexpected bin number when writing bam index " + n);
        }
        this.codec.writeInt(n);
        if (bin.getChunkList() == null) {
            this.codec.writeInt(0);
            return;
        }
        List<Chunk> list = bin.getChunkList();
        int n2 = list.size();
        this.codec.writeInt(n2);
        for (Chunk chunk : list) {
            this.codec.writeLong(chunk.getChunkStart());
            this.codec.writeLong(chunk.getChunkEnd());
        }
    }

    private void writeChunkMetaData(BAMIndexMetaData bAMIndexMetaData) {
        this.codec.writeInt(37450);
        this.codec.writeInt(2);
        this.codec.writeLong(bAMIndexMetaData.getFirstOffset());
        this.codec.writeLong(bAMIndexMetaData.getLastOffset());
        this.codec.writeLong(bAMIndexMetaData.getAlignedRecordCount());
        this.codec.writeLong(bAMIndexMetaData.getUnalignedRecordCount());
    }

    private void writeHeader() {
        byte[] byArray = BAMFileConstants.BAM_INDEX_MAGIC;
        this.codec.writeBytes(byArray);
        this.codec.writeInt(this.nRef);
    }

    private void writeNullContent() {
        this.codec.writeLong(0L);
    }
}

