/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichFeatureRelationship;
import org.biojavax.ontology.ComparableTerm;

public class SimpleRichFeatureRelationship
extends AbstractChangeable
implements RichFeatureRelationship {
    private RichFeature object;
    private RichFeature subject;
    private ComparableTerm term;
    private int rank;
    private Integer id;

    public static ComparableTerm getContainsTerm() {
        return RichObjectFactory.getDefaultOntology().getOrCreateTerm("contains");
    }

    public SimpleRichFeatureRelationship(RichFeature object, RichFeature subject, ComparableTerm term, int rank) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject cannot be null");
        }
        if (term == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        this.object = object;
        this.subject = subject;
        this.term = term;
        this.rank = rank;
    }

    protected SimpleRichFeatureRelationship() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRank(int rank) throws ChangeVetoException {
        if (!this.hasListeners(RichFeatureRelationship.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichFeatureRelationship.RANK, new Integer(rank), new Integer(this.rank));
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichFeatureRelationship.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getRank() {
        return this.rank;
    }

    public RichFeature getObject() {
        return this.object;
    }

    void setObject(RichFeature object) {
        this.object = object;
    }

    public RichFeature getSubject() {
        return this.subject;
    }

    void setSubject(RichFeature subject) {
        this.subject = subject;
    }

    public ComparableTerm getTerm() {
        return this.term;
    }

    void setTerm(ComparableTerm term) {
        this.term = term;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (this.object == null) {
            return -1;
        }
        RichFeatureRelationship them = (RichFeatureRelationship)o;
        if (this.rank != them.getRank()) {
            return this.rank - them.getRank();
        }
        if (!this.object.equals(them.getObject())) {
            return this.object.compareTo(them.getObject());
        }
        if (!this.subject.equals(them.getSubject())) {
            return this.subject.compareTo(them.getSubject());
        }
        return this.getTerm().compareTo(them.getTerm());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RichFeatureRelationship)) {
            return false;
        }
        if (this.object == null) {
            return false;
        }
        RichFeatureRelationship them = (RichFeatureRelationship)obj;
        return this.object.equals(them.getObject()) && this.subject.equals(them.getSubject()) && this.term.equals(them.getTerm());
    }

    public int hashCode() {
        int code = 17;
        if (this.subject == null) {
            return code;
        }
        code = code * 37 + this.object.hashCode();
        code = code * 37 + this.subject.hashCode();
        code = code * 37 + this.term.hashCode();
        return code;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.getTerm() + "(" + this.getObject() + "," + this.getSubject() + ")";
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

