/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology.io;

import java.io.BufferedReader;
import java.io.IOException;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyException;
import org.biojava.ontology.OntologyFactory;
import org.biojava.ontology.obo.OboFileHandler;
import org.biojava.ontology.obo.OboFileParser;
import org.biojava.utils.ChangeVetoException;

public class OboParser {
    public Ontology parseOBO(BufferedReader oboFile, String ontoName, String ontoDescription) throws ParseException, IOException {
        try {
            OntologyFactory factory = OntoTools.getDefaultFactory();
            Ontology ontology = factory.createOntology(ontoName, ontoDescription);
            OboFileParser parser = new OboFileParser();
            OboFileHandler handler = new OboFileHandler(ontology);
            parser.addOboFileEventListener(handler);
            parser.parseOBO(oboFile);
            return ontology;
        }
        catch (AlreadyExistsException ex) {
            throw new ParseException(ex, "Duplication in ontology");
        }
        catch (OntologyException ex) {
            throw new ParseException(ex);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Error accessing newly created ontology", ex);
        }
    }
}

