/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.agave.DelegationManager;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.SequenceHandler;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXContentHandlerBase;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeVetoException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StAXFeatureHandler
extends StAXContentHandlerBase {
    private boolean setOnceFired = false;
    protected String myLocalName;
    private boolean hasCallback = false;
    private List handlers;
    private boolean startFired = false;
    private boolean endFired = false;
    private boolean inFeature = false;
    protected Feature.Template featureTemplate;
    protected StAXFeatureHandler staxenv;
    protected SeqIOListener featureListener;
    protected int startLoc;
    protected int endLoc;
    protected List callbackStack;
    protected int stackLevel;
    protected List subFeatures;
    protected SimpleAnnotation annot = new SimpleAnnotation();

    StAXFeatureHandler(StAXFeatureHandler staxenv) {
        this.staxenv = staxenv;
        this.handlers = new ArrayList();
        this.callbackStack = new ArrayList();
        this.subFeatures = new ArrayList(1);
    }

    StAXFeatureHandler() {
        this.handlers = new ArrayList();
        this.callbackStack = new ArrayList();
        this.subFeatures = new ArrayList(1);
    }

    public void setHandlerCharacteristics(String localName, boolean hasCallback) {
        if (!this.setOnceFired) {
            this.myLocalName = localName;
            this.hasCallback = hasCallback;
            this.setOnceFired = true;
        }
    }

    public void setFeatureListener(SeqIOListener siol) {
        this.featureListener = siol;
    }

    protected void addHandler(ElementRecognizer rec, StAXHandlerFactory handler) {
        this.handlers.add(new Binding(rec, handler));
    }

    protected Feature.Template createTemplate() {
        StrandedFeature.Template st = new StrandedFeature.Template();
        st.source = this.myLocalName;
        st.type = this.myLocalName;
        st.strand = StrandedFeature.UNKNOWN;
        st.annotation = this.annot;
        st.location = Location.empty;
        if (this.staxenv != null) {
            this.staxenv.subFeatures.add(this);
        }
        return st;
    }

    protected void realizeSubFeatures(Feature feature) {
        try {
            for (StAXFeatureHandler handler : this.subFeatures) {
                if (handler instanceof SequenceHandler) continue;
                Feature f = feature.createFeature(handler.featureTemplate);
                handler.realizeSubFeatures(f);
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        catch (ChangeVetoException e) {
            e.printStackTrace();
        }
    }

    protected void addFeatureToSequence(Sequence seq) throws Exception {
        for (StAXFeatureHandler handler : this.subFeatures) {
            Feature f = seq.createFeature(handler.featureTemplate);
            handler.realizeSubFeatures(f);
        }
    }

    protected int getLevel() {
        return this.stackLevel;
    }

    protected ListIterator getHandlerStackIterator(int level) {
        return this.callbackStack.listIterator(level);
    }

    protected void push(StAXContentHandler handler) {
        this.callbackStack.add(handler);
        ++this.stackLevel;
    }

    protected void pop() {
        --this.stackLevel;
        this.callbackStack.remove(this.stackLevel);
    }

    public SeqIOListener getFeatureListener() {
        return this.featureListener;
    }

    private void fireStartFeature() throws ParseException {
        if (this.startFired) {
            throw new ParseException("startFeature event has already been fired");
        }
        if (this.featureTemplate == null) {
            this.featureTemplate = this.createTemplate();
        }
        if (this.featureTemplate.annotation == null) {
            this.featureTemplate.annotation = Annotation.EMPTY_ANNOTATION;
        }
        this.featureListener.startFeature(this.featureTemplate);
        this.startFired = true;
    }

    private void fireEndFeature() throws ParseException {
        if (!this.startFired) {
            throw new ParseException("startFeature has not yet been fired!");
        }
        if (this.endFired) {
            throw new ParseException("endFeature event has already been fired!");
        }
        this.featureListener.endFeature();
        this.endFired = true;
    }

    protected void setProperty(String name, String value, boolean forFeature) {
        if (value != null) {
            try {
                this.annot.setProperty(name, value);
                if (forFeature) {
                    this.featureListener.addFeatureProperty(name, value);
                } else {
                    this.featureListener.addSequenceProperty(name, value);
                }
            }
            catch (ChangeVetoException cae) {
                System.err.println(" veto exception caught.");
            }
            catch (ParseException cae) {
                System.err.println("parse exception in addProperty() .");
            }
        }
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        if (!this.setOnceFired) {
            throw new SAXException("StAXFeaturehandler not initialised before use!");
        }
        if (dm.getRecursive()) {
            for (int i = this.handlers.size() - 1; i >= 0; --i) {
                Binding b = (Binding)this.handlers.get(i);
                if (!b.recognizer.filterStartElement(nsURI, localName, qName, attrs)) continue;
                dm.delegate(b.handlerFactory.getHandler(this));
                return;
            }
        }
        if (!this.myLocalName.equals(localName)) {
            return;
        }
        if (!this.inFeature) {
            this.inFeature = true;
            if (this.hasCallback && this.stackLevel == 0) {
                this.push(this);
            }
            try {
                if (!this.startFired) {
                    this.fireStartFeature();
                }
            }
            catch (ParseException pe) {
                throw new SAXException("ParseException thrown in user code");
            }
        }
        this.startElementHandler(nsURI, localName, qName, attrs);
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        if (!this.myLocalName.equals(localName)) {
            return;
        }
        if (this.hasCallback) {
            this.pop();
        }
        if (this.stackLevel == 0) {
            try {
                if (!this.startFired) {
                    this.fireStartFeature();
                }
                if (!this.endFired) {
                    this.fireEndFeature();
                }
            }
            catch (ParseException pe) {
                throw new SAXException("ParseException thrown in user code");
            }
        }
        this.endElementHandler(nsURI, localName, qName, handler);
    }

    class Binding {
        final ElementRecognizer recognizer;
        final StAXHandlerFactory handlerFactory;

        Binding(ElementRecognizer er, StAXHandlerFactory hf) {
            this.recognizer = er;
            this.handlerFactory = hf;
        }
    }
}

