/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import com.google.common.base.Preconditions;
import edu.mayo.sage.NullLogger;
import edu.mayo.sage.Protocol;
import edu.mayo.sage.SagePropertyException;
import edu.mayo.sage.Usage;
import edu.mayo.sage.UsageLogger;
import edu.mayo.sage.UsageLoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageLoggerBuilder {
    private static final String ENVIRONMENT_VARIABLE = "environment variable";
    private static final String JAVA_PROPERTY = "java property";
    private static final String USER_SUPPLIED_OR_DEFAULT = "user supplied or default";
    private static final String FAIL_ON_ERROR_DESCRIPTION = "fail on error";
    private static final String PORT_DESCRIPTION = "port";
    private static final String SERVER_DESCRIPTION = "server";
    private static final String PROTOCOL_DESCRIPTION = "protocol";
    private static Logger logger = LoggerFactory.getLogger(UsageLoggerBuilder.class);
    private static final String CLIENT_HOST_DEFAULT = "0.0.0.0";
    private static final int CLIENT_PORT_DEFAULT = 0;
    private static final int SERVER_PORT_DEFAULT = 33124;
    private static final Protocol PROTOCOL_DEFAULT = Usage.PROTOCOL_DEFAULT;
    private static final boolean FAIL_ON_ERROR_DEFAULT = true;
    private String serverHost = null;
    private int serverPort = 33124;
    private String clientHost = "0.0.0.0";
    private int clientPort = 0;
    private Protocol protocol = PROTOCOL_DEFAULT;
    private boolean failOnError = true;

    public UsageLogger logger() throws SagePropertyException {
        String server = this.getServerHost();
        int port = this.getServerPort();
        if (server == null || "disable".equalsIgnoreCase(server.trim())) {
            logger.info(String.format("Using null logger. Server value is %s", server));
            return new NullLogger();
        }
        boolean failOnErrorLocal = this.getFailOnError();
        Protocol protocolLocal = this.getProtocol();
        logger.info(String.format("Getting usage logger using server:%s port:%d failOnError:%s protocol:%s", new Object[]{server, port, failOnErrorLocal, protocolLocal}));
        return protocolLocal.createLogger(this.getServerHost(), this.getServerPort(), this.clientHost, this.clientPort, this.getFailOnError());
    }

    public UsageLoggerBuilder protocol(Protocol protocol) {
        Preconditions.checkNotNull((Object)((Object)protocol));
        this.protocol = protocol;
        return this;
    }

    public Protocol getProtocol() throws SagePropertyException {
        String propName = "SAGE_PROTOCOL";
        String value = System.getenv(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogProtocol(ENVIRONMENT_VARIABLE, propName, value);
        }
        value = System.getProperty(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogProtocol(JAVA_PROPERTY, propName, value);
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(PROTOCOL_DESCRIPTION, USER_SUPPLIED_OR_DEFAULT, "", this.protocol.toString()));
        return this.protocol;
    }

    private static Protocol getAndLogProtocol(String sourceDescription, String propName, String protocolFromEnvironmentString) throws SagePropertyException {
        Protocol protocolFromEnvironment = Protocol.UDP;
        try {
            protocolFromEnvironment = Protocol.protocolFromString(protocolFromEnvironmentString, propName);
        }
        catch (SagePropertyException e) {
            UsageLoggerBuilder.throwSagePropertyExceptionWithBetterMessage(sourceDescription, propName, protocolFromEnvironmentString, e.getMessage());
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(PROTOCOL_DESCRIPTION, sourceDescription, propName, protocolFromEnvironmentString));
        return protocolFromEnvironment;
    }

    public UsageLoggerBuilder failOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public boolean getFailOnError() throws SagePropertyException {
        String propName = "SAGE_FAIL_ON_ERROR";
        String value = System.getenv(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogFailOnError(ENVIRONMENT_VARIABLE, propName, value);
        }
        value = System.getProperty(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogFailOnError(JAVA_PROPERTY, propName, value);
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(FAIL_ON_ERROR_DESCRIPTION, USER_SUPPLIED_OR_DEFAULT, "", Boolean.toString(this.failOnError)));
        return this.failOnError;
    }

    private static boolean getAndLogFailOnError(String sourceDescription, String propName, String failOnErrorFromEnvironmentString) throws SagePropertyException {
        boolean failOnErrorFromEnvironment = false;
        try {
            failOnErrorFromEnvironment = UsageLoggerUtils.booleanFromString(failOnErrorFromEnvironmentString, propName);
        }
        catch (SagePropertyException e) {
            UsageLoggerBuilder.throwSagePropertyExceptionWithBetterMessage(sourceDescription, propName, failOnErrorFromEnvironmentString, e.getMessage());
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(FAIL_ON_ERROR_DESCRIPTION, sourceDescription, propName, failOnErrorFromEnvironmentString));
        return failOnErrorFromEnvironment;
    }

    public UsageLoggerBuilder clientHost(String clientHost) {
        this.clientHost = clientHost;
        return this;
    }

    public UsageLoggerBuilder clientPort(int clientPort) {
        this.clientPort = clientPort;
        return this;
    }

    public UsageLoggerBuilder serverHost(String serverHost) throws SagePropertyException {
        if (serverHost != null && "".equals(serverHost.trim())) {
            String msg = "Server not allowed to be empty. Set it to 'disable' to explicitly turn off usage logging";
            throw new SagePropertyException(msg);
        }
        this.serverHost = serverHost;
        return this;
    }

    public String getServerHost() throws SagePropertyException {
        String propName = "SAGE_SERVER";
        String value = System.getenv(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogServer(ENVIRONMENT_VARIABLE, propName, value);
        }
        value = System.getProperty(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogServer(JAVA_PROPERTY, propName, value);
        }
        if (this.serverHost != null) {
            logger.debug(UsageLoggerBuilder.composeValueInfoMessage(SERVER_DESCRIPTION, USER_SUPPLIED_OR_DEFAULT, propName, this.serverHost));
            return this.serverHost.trim();
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(SERVER_DESCRIPTION, USER_SUPPLIED_OR_DEFAULT, propName, "null"));
        return null;
    }

    private static String getAndLogServer(String sourceDescription, String propName, String serverFromEnvironment) throws SagePropertyException {
        if ("".equals(serverFromEnvironment.trim())) {
            String msg = String.format("%s %s is not allowed to be an empty string. Set it to 'disable' to explicity turn off usage logging.", sourceDescription, propName);
            logger.error(msg);
            throw new SagePropertyException(msg);
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(SERVER_DESCRIPTION, sourceDescription, propName, serverFromEnvironment));
        return serverFromEnvironment.trim();
    }

    public UsageLoggerBuilder serverPort(int serverPort) throws SagePropertyException {
        if (serverPort <= 0) {
            String msg = String.format("Can't set port <= 0. Supplied value is %d", serverPort);
            throw new SagePropertyException(msg);
        }
        this.serverPort = serverPort;
        return this;
    }

    public int getServerPort() throws SagePropertyException {
        String propName = "SAGE_PORT";
        String value = System.getenv(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogPort(ENVIRONMENT_VARIABLE, propName, value);
        }
        value = System.getProperty(propName);
        if (value != null) {
            return UsageLoggerBuilder.getAndLogPort(JAVA_PROPERTY, propName, value);
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(PORT_DESCRIPTION, USER_SUPPLIED_OR_DEFAULT, "", Integer.toString(this.serverPort)));
        return this.serverPort;
    }

    private static int getAndLogPort(String sourceDescription, String propName, String portFromEnvironmentString) throws SagePropertyException {
        int portFromEnvironment = -1;
        try {
            portFromEnvironment = UsageLoggerUtils.intFromString(portFromEnvironmentString, propName);
        }
        catch (SagePropertyException e) {
            UsageLoggerBuilder.throwSagePropertyExceptionWithBetterMessage(sourceDescription, propName, portFromEnvironmentString, e.getMessage());
        }
        logger.debug(UsageLoggerBuilder.composeValueInfoMessage(PORT_DESCRIPTION, sourceDescription, propName, portFromEnvironmentString));
        return portFromEnvironment;
    }

    private static void throwSagePropertyExceptionWithBetterMessage(String sourceDescription, String propName, String value, String origMessage) throws SagePropertyException {
        String msg = String.format("%s %s was set but %s wasn't an allowed value. Details: %s", sourceDescription, propName, value, origMessage);
        logger.error(msg);
        throw new SagePropertyException(msg);
    }

    private static String composeValueInfoMessage(String sagePropertyDescription, String varDescription, String varName, String value) {
        return String.format("Using value %s for %s from %s %s", value, sagePropertyDescription, varDescription, varName);
    }
}

