/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import com.google.common.base.Preconditions;
import edu.mayo.sage.SagePropertyException;
import edu.mayo.sage.TcpLogger;
import edu.mayo.sage.UdpLogger;
import edu.mayo.sage.UsageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Protocol {
    UDP,
    TCP;


    public static Protocol protocolFromString(String protocolStringValue, String propName) throws SagePropertyException {
        Preconditions.checkNotNull((Object)protocolStringValue);
        if ("udp".equalsIgnoreCase(protocolStringValue.trim())) {
            return UDP;
        }
        if ("tcp".equalsIgnoreCase(protocolStringValue.trim())) {
            return TCP;
        }
        String msg = String.format("%s from %s should be udp/tcp (case insensitive)", protocolStringValue, propName);
        throw new SagePropertyException(msg);
    }

    UsageLogger createLogger(String serverHost, int serverPort, String clientHost, int clientPort, boolean failOnError) {
        switch (this) {
            case TCP: {
                return new TcpLogger(serverHost, serverPort, clientHost, clientPort, failOnError);
            }
            case UDP: {
                return new UdpLogger(serverHost, serverPort, clientHost, clientPort, failOnError);
            }
        }
        throw new RuntimeException(String.format("Programming Error: Need to handle protocol %s", new Object[]{this}));
    }
}

