/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.alignment.blast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.biojava.bio.BioException;
import org.biojavax.bio.alignment.RemotePairwiseAlignmentOutputProperties;
import org.biojavax.bio.alignment.RemotePairwiseAlignmentProperties;
import org.biojavax.bio.alignment.RemotePairwiseAlignmentService;
import org.biojavax.bio.seq.RichSequence;

public class RemoteQBlastService
implements RemotePairwiseAlignmentService {
    private static String baseurl = "http://www.ncbi.nlm.nih.gov/blast/Blast.cgi";
    private URL aUrl;
    private URLConnection uConn;
    private OutputStreamWriter fromQBlast;
    private BufferedReader rd;
    private String email = "anonymous@biojava.org";
    private String tool = "biojavax";
    private String seq = null;
    private String prog = null;
    private String db = null;
    private String rid;
    private long step;
    private long start;
    private HashMap<String, Long> holder = new HashMap();

    public RemoteQBlastService() throws BioException {
        try {
            this.aUrl = new URL(baseurl);
            this.uConn = this.setQBlastServiceProperties(this.aUrl.openConnection());
        }
        catch (MalformedURLException e) {
            throw new BioException("It looks like the URL for NCBI QBlast service is wrong.\n");
        }
        catch (IOException e) {
            throw new BioException("Impossible to connect to QBlast service at this time. Check your network connection.\n");
        }
    }

    private String sendActualAlignementRequest(String str, RemotePairwiseAlignmentProperties rpa) throws BioException {
        this.seq = "QUERY=" + str;
        this.prog = "PROGRAM=" + rpa.getAlignmentOption("PROGRAM");
        this.db = "DATABASE=" + rpa.getAlignmentOption("DATABASE");
        if (this.prog == null || this.db == null || str == null || str.length() == 0) {
            throw new BioException("Impossible to execute QBlast request. One or more of sequence|database|program has not been set correctly.\n");
        }
        String cmd = "CMD=Put&SERVICE=plain&" + this.seq + "&" + this.prog + "&" + this.db + "&" + "FORMAT_TYPE=HTML" + "&TOOL=" + this.getTool() + "&EMAIL=" + this.getEmail();
        if (rpa.getAlignmentOption("OTHER_ADVANCED") != null) {
            cmd = cmd + cmd + "&" + rpa.getAlignmentOption("OTHER_ADVANCED");
        }
        try {
            this.uConn = this.setQBlastServiceProperties(this.aUrl.openConnection());
            this.fromQBlast = new OutputStreamWriter(this.uConn.getOutputStream());
            this.fromQBlast.write(cmd);
            this.fromQBlast.flush();
            this.rd = new BufferedReader(new InputStreamReader(this.uConn.getInputStream()));
            String line = "";
            while ((line = this.rd.readLine()) != null) {
                String[] arr;
                if (line.contains("RID")) {
                    arr = line.split("=");
                    this.rid = arr[1].trim();
                } else if (line.contains("RTOE")) {
                    arr = line.split("=");
                    this.step = Long.parseLong(arr[1].trim()) * 1000L;
                    this.start = System.currentTimeMillis() + this.step;
                }
                this.holder.put(this.rid, this.start);
            }
        }
        catch (IOException e) {
            throw new BioException("Can't submit sequence to BLAST server at this time.\n");
        }
        return this.rid;
    }

    public String sendAlignmentRequest(String str, RemotePairwiseAlignmentProperties rpa) throws BioException {
        this.rid = this.sendActualAlignementRequest(this.seq, rpa);
        return this.rid;
    }

    public String sendAlignmentRequest(RichSequence rs, RemotePairwiseAlignmentProperties rpa) throws BioException {
        this.seq = rs.seqString();
        this.rid = this.sendActualAlignementRequest(this.seq, rpa);
        return this.rid;
    }

    public String sendAlignmentRequest(int gid, RemotePairwiseAlignmentProperties rpa) throws BioException {
        this.seq = Integer.toString(gid);
        this.rid = this.sendActualAlignementRequest(this.seq, rpa);
        return this.rid;
    }

    public boolean isReady(String id, long present) throws BioException {
        boolean ready = false;
        String check = "CMD=Get&RID=" + id;
        if (this.holder.containsKey(id)) {
            if (present < this.start) {
                ready = false;
            } else {
                try {
                    this.uConn = this.setQBlastServiceProperties(this.aUrl.openConnection());
                    this.fromQBlast = new OutputStreamWriter(this.uConn.getOutputStream());
                    this.fromQBlast.write(check);
                    this.fromQBlast.flush();
                    this.rd = new BufferedReader(new InputStreamReader(this.uConn.getInputStream()));
                    String line = "";
                    while ((line = this.rd.readLine()) != null) {
                        if (line.contains("READY")) {
                            ready = true;
                            continue;
                        }
                        if (!line.contains("WAITING")) continue;
                        this.start = present + this.step;
                        this.holder.put(id, this.start);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new BioException("Impossible to check for request ID named " + id + " because it does not exists!\n");
        }
        return ready;
    }

    public InputStream getAlignmentResults(String id, RemotePairwiseAlignmentOutputProperties rb) throws BioException {
        if (this.holder.containsKey(id)) {
            String srid = "CMD=Get&RID=" + id + "&" + rb.getOutputOption("FORMAT_TYPE") + "&" + rb.getOutputOption("ALIGNMENT_VIEW") + "&" + rb.getOutputOption("DESCRIPTIONS") + "&" + rb.getOutputOption("ALIGNMENTS") + "&TOOL=" + this.getTool() + "&EMAIL=" + this.getEmail();
            try {
                this.uConn = this.setQBlastServiceProperties(this.aUrl.openConnection());
                this.fromQBlast = new OutputStreamWriter(this.uConn.getOutputStream());
                this.fromQBlast.write(srid);
                this.fromQBlast.flush();
                return this.uConn.getInputStream();
            }
            catch (IOException ioe) {
                throw new BioException("It is not possible to fetch Blast report from NCBI at this time.\n");
            }
        }
        throw new BioException("Impossible to get output for request ID named " + id + " because it does not exists!\n");
    }

    public void printRemoteBlastInfo() throws BioException {
        try {
            OutputStreamWriter out = new OutputStreamWriter(this.uConn.getOutputStream());
            out.write("CMD=Info");
            out.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(this.uConn.getInputStream()));
            String line = "";
            while ((line = rd.readLine()) != null) {
                System.out.println(line);
            }
            out.close();
            rd.close();
        }
        catch (IOException e) {
            throw new BioException("Impossible to get info from QBlast service at this time. Check your network connection.\n");
        }
    }

    private URLConnection setQBlastServiceProperties(URLConnection conn) {
        URLConnection tmp = conn;
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        tmp.setRequestProperty("User-Agent", "Biojava/RemoteQBlastService");
        tmp.setRequestProperty("Connection", "Keep-Alive");
        tmp.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        tmp.setRequestProperty("Content-length", "200");
        return tmp;
    }

    public void setTool(String tool) {
        this.tool = tool;
    }

    public String getTool() {
        return this.tool;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }
}

