/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class StreamConnector
implements Runnable {
    private final Logger sLogger = Logger.getLogger(StreamConnector.class);
    private InputStream mInStream;
    private OutputStream mOutStream;
    private int mBufferSize;

    public StreamConnector(InputStream in, OutputStream out, int bufferSize) {
        this.mInStream = in;
        this.mOutStream = out;
        this.mBufferSize = bufferSize;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[this.mBufferSize];
        try {
            int n = 0;
            while (n != -1) {
                this.mOutStream.write(buffer, 0, n);
                this.mOutStream.flush();
                n = this.mInStream.read(buffer);
            }
            this.mOutStream.close();
        }
        catch (IOException ioe) {
            this.sLogger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }
}

