/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import edu.mayo.bior.pipeline.VEP.SiftPolyphenScore;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class VepCsqSiftPolyphenComparator
implements Comparator<SiftPolyphenScore> {
    private static final Map<String, Integer> sTermMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
    private static final Logger sLogger = Logger.getLogger(VepCsqSiftPolyphenComparator.class);

    @Override
    public int compare(SiftPolyphenScore score1, SiftPolyphenScore score2) {
        int termWeight2;
        int termWeight1 = this.getTermWeight(score1);
        if (termWeight1 > (termWeight2 = this.getTermWeight(score2))) {
            return -1;
        }
        if (termWeight1 < termWeight2) {
            return 1;
        }
        if (score1.siftScore < score2.siftScore) {
            return -1;
        }
        if (score2.siftScore < score1.siftScore) {
            return 1;
        }
        if (score1.polyphenScore > score2.polyphenScore) {
            return -1;
        }
        if (score2.polyphenScore > score1.polyphenScore) {
            return 1;
        }
        return score1.feature.compareToIgnoreCase(score2.feature);
    }

    protected int getTermWeight(SiftPolyphenScore score) {
        int siftWeight = this.getWeight(score.siftTerm, true);
        int polyphenWeight = this.getWeight(score.polyphenTerm, false);
        return siftWeight + polyphenWeight;
    }

    protected int getWeight(String term, boolean isSiftTerm) {
        Integer weight = 0;
        if (term == null || term.length() == 0) {
            weight = 0;
        } else if (!sTermMap.containsKey(term)) {
            weight = 0;
            String MSG = "Warning: VEP CSQ " + (isSiftTerm ? "SIFT" : "PolyPhen") + " term not recognized: " + term;
            System.err.println(MSG);
            sLogger.warn((Object)MSG);
        } else {
            weight = sTermMap.get(term);
        }
        return weight;
    }

    static {
        sTermMap.put("deleterious", 5);
        sTermMap.put("tolerated", 0);
        sTermMap.put("probably_damaging", 5);
        sTermMap.put("possibly_damaging", 3);
        sTermMap.put("unknown", 1);
        sTermMap.put("benign", 0);
    }
}

