/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.bior.pipeline.VcfInfoColumnBuilder;
import edu.mayo.bior.util.ColumnResolver;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class TjsonToVcfPipe
extends AbstractPipe<History, History> {
    public final String DEFAULT_DESCRIPTION = "BioR property file missing description";
    public final String DEFAULT_TYPE = "String";
    public final String DEFAULT_NUMBER = ".";
    private final int INFO_COL = 7;
    private final int NUM_REQUIRED_VCF_COLS = 8;
    protected static int QUEUE_LIMIT = 1000;
    private List<History> mLineQueue = new ArrayList<History>();
    private static final Logger sLogger = Logger.getLogger(TjsonToVcfPipe.class);
    Map<Integer, String> biorindexes = new LinkedHashMap<Integer, String>();
    private boolean mIsHeaderModified = false;
    private Map<String, ColumnMetaData> mInfoMetadata = new HashMap<String, ColumnMetaData>();
    private int mJsonColumn = -1;
    private boolean mIsKeepAllColumns = false;
    private boolean mIsAddDataToInfo = false;
    private boolean mIsAddJsonToInfo = false;
    private String mColumnsToCollapseUserInputString = null;
    private TreeSet<Integer> mColumnsToAddToInfo = null;
    private TreeSet<Integer> mColumnsToRemove = null;
    private TreeSet<Integer> mJsonColumns;
    private long mLineNum = 0L;
    private Gson gson = new Gson();
    private JsonParser jsonParser = new JsonParser();
    private VcfInfoColumnBuilder mVcfInfoColumnBuilder = new VcfInfoColumnBuilder();
    private boolean mIsAlreadyAVcf;
    private boolean mIsPrevPipeHasNext = true;

    public TjsonToVcfPipe(int jsonCol, boolean isKeepAllColumns, boolean isAddDataToInfo, boolean isAddJsonToInfo, String colRangeToCollapseToInfoCol) {
        this.mJsonColumn = jsonCol;
        this.mIsKeepAllColumns = isKeepAllColumns;
        this.mIsAddDataToInfo = isAddDataToInfo;
        this.mIsAddJsonToInfo = isAddJsonToInfo;
        this.mColumnsToCollapseUserInputString = colRangeToCollapseToInfoCol;
        if (this.mColumnsToCollapseUserInputString == null) {
            this.mColumnsToCollapseUserInputString = "";
        }
    }

    public TjsonToVcfPipe(int jsonCol) {
        this(jsonCol, false, true, false, "");
    }

    public TjsonToVcfPipe() {
        this(-1, false, true, false, "");
    }

    protected History processNextStart() throws NoSuchElementException {
        History history;
        while (this.mIsPrevPipeHasNext && (this.mIsPrevPipeHasNext = this.starts.hasNext()) && this.mLineQueue.size() < QUEUE_LIMIT) {
            history = (History)this.starts.next();
            if (this.isBlankLine(history)) continue;
            this.mLineQueue.add(history);
        }
        if (this.mLineQueue.size() == 0) {
            if (this.mLineNum == 0L) {
                System.err.println("Warning: No data lines available, so headers could not be modified.");
            } else {
                throw new NoSuchElementException("No more data to process");
            }
        }
        history = this.mLineQueue.get(0);
        History historyAsVcf = this.lineToVcf(history);
        this.mLineQueue.remove(0);
        return historyAsVcf;
    }

    private TreeSet<Integer> getColumnsToAddToInfoColumn(History history, int targetJsonToBuildVcf8Cols, List<History> lineQueue) throws Exception {
        TreeSet<Integer> columnsToAddToInfo = new TreeSet<Integer>(Collections.reverseOrder());
        if (!this.mIsAddDataToInfo) {
            return columnsToAddToInfo;
        }
        if (this.mColumnsToCollapseUserInputString.length() > 0) {
            columnsToAddToInfo.addAll(ColumnResolver.rangesToZeroBasedIndexes(history, this.mColumnsToCollapseUserInputString));
        } else {
            columnsToAddToInfo.addAll(this.getAllBiorColumns(history));
            if (this.mIsAddJsonToInfo) {
                columnsToAddToInfo.add(targetJsonToBuildVcf8Cols);
            } else {
                columnsToAddToInfo.removeAll(this.getJsonColumns(lineQueue));
            }
        }
        return columnsToAddToInfo;
    }

    private TreeSet<Integer> getColumnsToRemove(History history, boolean isKeepAllColumns, boolean isAlreadyAVcf, int targetJsonToBuildVcf8Cols) throws Exception {
        TreeSet<Integer> columnsToRemove = new TreeSet<Integer>(Collections.reverseOrder());
        if (isKeepAllColumns) {
            return columnsToRemove;
        }
        columnsToRemove.addAll(this.getAllBiorColumns(history));
        if (this.mVcfInfoColumnBuilder.isJsonObject((String)history.get(targetJsonToBuildVcf8Cols))) {
            columnsToRemove.add(targetJsonToBuildVcf8Cols);
        }
        columnsToRemove.addAll(ColumnResolver.rangesToZeroBasedIndexes(history, this.mColumnsToCollapseUserInputString));
        if (isAlreadyAVcf) {
            columnsToRemove.removeAll(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7));
        }
        return columnsToRemove;
    }

    private void removeDuplicates(List<Integer> list) {
        block0: for (int i = list.size() - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (list.get(i) != list.get(j)) continue;
                list.remove(i);
                continue block0;
            }
        }
    }

    private List<Integer> getAllBiorColumns(History history) {
        Set<String> biorColumnNamesFromMetadata = this.getBiorColumnIdsFromMetadata(history.getMetaData().getOriginalHeader());
        ArrayList<Integer> biorColumnIndexes = new ArrayList<Integer>();
        List columnMetaList = history.getMetaData().getColumns();
        for (int i = 0; i < columnMetaList.size(); ++i) {
            String colName = ((ColumnMetaData)columnMetaList.get(i)).getColumnName();
            if (!colName.toLowerCase().startsWith("bior") && !biorColumnNamesFromMetadata.contains(colName)) continue;
            biorColumnIndexes.add(i);
        }
        return biorColumnIndexes;
    }

    public Set<String> getBiorColumnIdsFromMetadata(List<String> metadataLines) {
        HashSet<String> columns = new HashSet<String>();
        for (String metadataLine : metadataLines) {
            if (!metadataLine.startsWith("##BIOR=<ID")) continue;
            columns.add(this.getIdFromBiorMetadata(metadataLine));
        }
        return columns;
    }

    private String getIdFromBiorMetadata(String biorMetadataLine) {
        String PREFIX = "##BIOR=<ID=";
        int idxIdStart = biorMetadataLine.indexOf("##BIOR=<ID=");
        int idxIdEnd = biorMetadataLine.indexOf(",", idxIdStart);
        if (idxIdEnd == -1) {
            idxIdEnd = biorMetadataLine.indexOf(">", idxIdStart);
        }
        if (idxIdStart == -1 || idxIdEnd == -1) {
            return "";
        }
        return biorMetadataLine.substring(idxIdStart + "##BIOR=<ID=".length(), idxIdEnd).replaceAll("\"", "");
    }

    protected History lineToVcf(History history) {
        try {
            if (this.isBlankLine(history)) {
                return new History();
            }
            this.modifyHeaderMetadataOnce(history);
            return this.modifyDataLine(history);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvalidDataException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isBlankLine(History history) {
        return history == null || history.size() == 0 || history.size() == 1 && ((String)history.get(0)).trim().length() == 0;
    }

    private void modifyHeaderMetadataOnce(History history) throws Exception {
        if (!this.mIsHeaderModified) {
            if (this.mLineQueue.size() == 0) {
                this.mLineQueue.add(history);
            }
            this.mIsAlreadyAVcf = this.isAlreadyAVcf(history);
            this.mJsonColumn = ColumnResolver.numberToZeroBasedIndex(history, this.mJsonColumn, this.mLineNum);
            this.mColumnsToAddToInfo = this.getColumnsToAddToInfoColumn(history, this.mJsonColumn, this.mLineQueue);
            this.mColumnsToRemove = this.getColumnsToRemove(history, this.mIsKeepAllColumns, this.mIsAlreadyAVcf, this.mJsonColumn);
            this.addInfoHeaderLines(history);
            this.addTopMostHeaders(history);
            this.modifyHeaderLineToVcfFormat(history);
            this.mIsHeaderModified = true;
        }
    }

    private void addInfoHeaderLines(History history) throws Exception {
        this.mColumnsToAddToInfo = this.getColumnsToAddToInfoColumn(history, this.mJsonColumn, this.mLineQueue);
        List<String> infoMetaHeaders = this.mVcfInfoColumnBuilder.createInfoMetadata(this.mLineQueue, this.mColumnsToAddToInfo);
        if (!this.mIsAlreadyAVcf && this.mIsAddDataToInfo) {
            infoMetaHeaders.addAll(this.mVcfInfoColumnBuilder.createInfoMetadataFromInfoInTargetJsonCol(this.mLineQueue, this.mJsonColumn));
        }
        if (this.mIsAddDataToInfo) {
            for (String infoMetaHeader : infoMetaHeaders) {
                this.mVcfInfoColumnBuilder.addInfoLineToHeader(history, infoMetaHeader);
            }
        }
    }

    private History modifyDataLine(History history) {
        ++this.mLineNum;
        String newInfoValues = "";
        if (this.mIsAddDataToInfo) {
            if (!this.mIsAddJsonToInfo) {
                this.removeColsFromListIfJson(this.mColumnsToAddToInfo, history);
            }
            newInfoValues = this.mVcfInfoColumnBuilder.createInfoData(history, this.mColumnsToAddToInfo);
        }
        List<Object> vcfRequiredColsToInsert = new ArrayList();
        if (!this.mIsAlreadyAVcf) {
            vcfRequiredColsToInsert = this.getRequiredVcfColumnsToInsertIntoDataLine(history);
        }
        this.removeTargetAndSpecifiedColumns(history, this.mColumnsToRemove);
        history.addAll(0, vcfRequiredColsToInsert);
        String infoCol = this.mergeOldInfoValuesWithNew((String)history.get(7), newInfoValues);
        history.set(7, (Object)infoCol);
        return history;
    }

    private void removeColsFromListIfJson(TreeSet<Integer> colsToCollapseSet, History history) {
        Integer[] colsToCollapse;
        for (Integer col : colsToCollapse = colsToCollapseSet.toArray(new Integer[colsToCollapseSet.size()])) {
            if (!this.mVcfInfoColumnBuilder.isJsonObject((String)history.get(col.intValue()))) continue;
            colsToCollapseSet.remove(col);
        }
    }

    private List<Integer> getJsonColumns(List<History> lineQueue) {
        int col;
        int numCols = lineQueue.get(0).size();
        Boolean[] isJsonCol = new Boolean[numCols];
        for (col = 0; col < isJsonCol.length; ++col) {
            isJsonCol[col] = this.isDataTypeJson(col, lineQueue.get(0)) ? Boolean.valueOf(true) : null;
        }
        for (col = 0; col < numCols; ++col) {
            for (int row = 0; row < lineQueue.size() && (isJsonCol[col] == null || isJsonCol[col].booleanValue()); ++row) {
                String colStr = (String)lineQueue.get(row).get(col);
                if (this.mVcfInfoColumnBuilder.isJsonObject(colStr)) {
                    if (isJsonCol[col] != null) continue;
                    isJsonCol[col] = true;
                    continue;
                }
                if (".".equals(colStr)) continue;
                isJsonCol[col] = false;
            }
        }
        ArrayList<Integer> jsonColumns = new ArrayList<Integer>();
        for (int i = 0; i < isJsonCol.length; ++i) {
            if (isJsonCol[i] == null || !isJsonCol[i].booleanValue()) continue;
            jsonColumns.add(i);
        }
        return jsonColumns;
    }

    private List<Integer> getNonJsonCols(List<Integer> columnsToCollapseList, List<Integer> jsonCols) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        for (int col : columnsToCollapseList) {
            boolean isJson = false;
            for (int jsonCol : jsonCols) {
                if (col != jsonCol) continue;
                isJson = true;
            }
            if (isJson) continue;
            cols.add(col);
        }
        return cols;
    }

    private boolean isDataTypeJson(int col, History line) {
        String colName = ((ColumnMetaData)line.getMetaData().getColumns().get(col)).getColumnName();
        String metaHeaderLine = this.getBiorHeaderByKey(colName, line);
        if (metaHeaderLine == null) {
            return false;
        }
        return metaHeaderLine.contains("DataType=\"JSON\"");
    }

    private String getBiorHeaderByKey(String key, History line) {
        String keyWithPrefix = "##BIOR=<ID=\"" + key + "\"";
        for (String header : line.getMetaData().getOriginalHeader()) {
            if (!header.startsWith(keyWithPrefix)) continue;
            return header;
        }
        return null;
    }

    protected String mergeOldInfoValuesWithNew(String oldInfoValues, String newInfoValues) {
        String merged = "";
        merged = this.isNullBlankOrDot(oldInfoValues) ? newInfoValues : (this.isNullBlankOrDot(newInfoValues) ? oldInfoValues : oldInfoValues + ";" + newInfoValues);
        if (merged.length() == 0) {
            merged = ".";
        }
        return merged;
    }

    private boolean isNullBlankOrDot(String val) {
        return val == null || val.length() == 0 || ".".equals(val);
    }

    protected boolean isAlreadyAVcf(History history) {
        HistoryMetaData metadata = history.getMetaData();
        if (metadata == null) {
            throw new IllegalStateException("Error: Header information is required to construct the VCF");
        }
        String header = metadata.getColumnHeaderRow(history, "\t");
        String[] columnHeaders = header.split("\t");
        return columnHeaders != null && columnHeaders.length >= 8 && columnHeaders[0].equalsIgnoreCase("#CHROM") && columnHeaders[1].equalsIgnoreCase("POS") && columnHeaders[2].equalsIgnoreCase("ID") && columnHeaders[3].equalsIgnoreCase("REF") && columnHeaders[4].equalsIgnoreCase("ALT") && columnHeaders[5].equalsIgnoreCase("QUAL") && columnHeaders[6].equalsIgnoreCase("FILTER") && columnHeaders[7].equalsIgnoreCase("INFO");
    }

    private List<String> getRequiredVcfColumnsToInsertIntoDataLine(History history) {
        JsonElement jsonElem = this.getJsonElementFromColumn((String)history.get(this.mJsonColumn));
        String chrom = this.getJsonVal(jsonElem, "_landmark", true, this.mLineNum);
        String pos = this.getJsonVal(jsonElem, "_minBP", true, this.mLineNum);
        String id = this.getJsonVal(jsonElem, "_id", false, this.mLineNum);
        String ref = this.getJsonVal(jsonElem, "_refAllele", true, this.mLineNum);
        String alt = this.splitAlts(this.getJsonVal(jsonElem, "_altAlleles", true, this.mLineNum));
        String qual = this.getJsonVal(jsonElem, "QUAL", false, this.mLineNum);
        String filter = this.getJsonVal(jsonElem, "FILTER", false, this.mLineNum);
        String info = ".";
        if (id.equals(".")) {
            id = this.getJsonVal(jsonElem, "ID", false, this.mLineNum);
        }
        if (this.mIsAddDataToInfo && this.mVcfInfoColumnBuilder.isJsonObject(info = this.getJsonVal(jsonElem, "INFO", false, this.mLineNum))) {
            JsonObject infoJsonObj = this.jsonParser.parse(info).getAsJsonObject();
            info = this.mVcfInfoColumnBuilder.jsonObjectToInfoDataString("", infoJsonObj);
        }
        List<String> colsToInsert = Arrays.asList(chrom, pos, id, ref, alt, qual, filter, info);
        return colsToInsert;
    }

    private JsonElement getJsonElementFromColumn(String json) {
        JsonElement jsonElem = null;
        try {
            jsonElem = this.jsonParser.parse(json);
            JsonObject jsonObject = jsonElem.getAsJsonObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error: Data line " + this.mLineNum + ":  Target column not JSON.  Was: " + json);
        }
        return jsonElem;
    }

    private void removeTargetAndSpecifiedColumns(History history, TreeSet<Integer> columnsToRemoveSet) {
        Integer[] colsToRemove;
        for (Integer biorCol : colsToRemove = columnsToRemoveSet.toArray(new Integer[columnsToRemoveSet.size()])) {
            history.remove(biorCol.intValue());
        }
    }

    protected String getJsonVal(JsonElement jsonElem, String key, boolean isRequired, long lineNum) {
        JsonElement obj = jsonElem.getAsJsonObject().get(key);
        if (isRequired && obj == null) {
            throw new IllegalStateException("Error: Required JSON field [" + key + "] missing on data line " + lineNum + ": Target column must contain these JSON fields: _landmark, _minBP, _refAllele, _altAlleles.  Was: " + jsonElem.toString());
        }
        String val = ".";
        val = obj == null ? "." : (obj.isJsonPrimitive() ? obj.getAsString() : obj.toString());
        return val;
    }

    protected String splitAlts(String jsonAltArray) {
        return jsonAltArray.replace("[", "").replace("]", "").replaceAll("\"", "");
    }

    private void modifyHeaderLineToVcfFormat(History history) {
        this.removeColumnMetaData(history, this.mColumnsToRemove);
        if (!this.mIsAlreadyAVcf) {
            this.insertVcfRequiredColumnsIntoHeader(history);
        }
    }

    private void removeColumnMetaData(History history, TreeSet<Integer> columnsToRemoveSet) {
        Integer[] colsToRemove = columnsToRemoveSet.toArray(new Integer[columnsToRemoveSet.size()]);
        List colMetaData = history.getMetaData().getColumns();
        for (Integer biorCol : colsToRemove) {
            colMetaData.remove(biorCol);
        }
    }

    private void insertVcfRequiredColumnsIntoHeader(History history) {
        History colHeaderLine;
        List headerLines = history.getMetaData().getOriginalHeader();
        History history2 = colHeaderLine = headerLines.size() > 0 ? new History((String)headerLines.get(headerLines.size() - 1)) : new History();
        if (colHeaderLine.size() > 0) {
            colHeaderLine.set(0, (Object)((String)colHeaderLine.get(0)).replace("#", ""));
        }
        colHeaderLine.addAll(0, Arrays.asList("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO"));
        if (headerLines.size() > 0) {
            headerLines.set(headerLines.size() - 1, colHeaderLine.getMergedData("\t"));
        } else {
            headerLines.add(colHeaderLine.getMergedData("\t"));
        }
        List meta = history.getMetaData().getColumns();
        meta.addAll(0, Arrays.asList(new ColumnMetaData("CHROM", ColumnMetaData.Type.String, "1", "Chromosome"), new ColumnMetaData("POS", ColumnMetaData.Type.String, "1", "Position"), new ColumnMetaData("ID", ColumnMetaData.Type.String, "1", "Id or rsId"), new ColumnMetaData("REF", ColumnMetaData.Type.String, "1", "Reference Allele"), new ColumnMetaData("ALT", ColumnMetaData.Type.String, ".", "Alternate Alleles"), new ColumnMetaData("QUAL", ColumnMetaData.Type.String, "1", "Quality"), new ColumnMetaData("FILTER", ColumnMetaData.Type.String, "1", "Filter"), new ColumnMetaData("INFO", ColumnMetaData.Type.String, ".", "Info")));
    }

    private void addTopMostHeaders(History history) {
        List headers = history.getMetaData().getOriginalHeader();
        if (!this.isHeaderExists("##fileformat", history)) {
            headers.add(0, "##fileformat=VCFv4.1");
        }
        if (!this.isHeaderExists("##fileDate", history)) {
            this.insertAfter("##fileDate=" + new SimpleDateFormat("yyyyMMdd").format(new Date()), "##fileformat", history);
        }
        if (!this.isHeaderExists("##source", history)) {
            this.insertAfter("##source=bior_tjson_to_vcf", "##fileDate", history);
        }
    }

    private void insertAfter(String headerLine, String keyToInsertAfter, History history) {
        int lineOfKeyToInsertAfter = this.getHeaderRowIndex(keyToInsertAfter, history);
        history.getMetaData().getOriginalHeader().add(lineOfKeyToInsertAfter + 1, headerLine);
    }

    protected boolean isHeaderExists(String headerKey, History history) {
        return -1 != this.getHeaderRowIndex(headerKey, history);
    }

    private int getHeaderRowIndex(String headerKey, History history) {
        List headers = history.getMetaData().getOriginalHeader();
        for (int i = 0; i < headers.size(); ++i) {
            String key;
            int idxEq = ((String)headers.get(i)).indexOf("=");
            if (idxEq == -1 || !headerKey.equalsIgnoreCase(key = ((String)headers.get(i)).substring(0, idxEq))) continue;
            return i;
        }
        return -1;
    }

    public HistoryMetaData removeColumnHeader(HistoryMetaData metaData, Map<Integer, String> biorindexes2) {
        List columns = metaData.getColumns();
        ArrayList<Integer> indexes = new ArrayList<Integer>(biorindexes2.keySet());
        Collections.sort(indexes);
        Collections.reverse(indexes);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            ColumnMetaData cmd = (ColumnMetaData)columns.get(j);
            columns.remove(cmd);
        }
        return metaData;
    }
}

