/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.buildcatalog.TempDirectory;
import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.pipeline.createcatalog.TjsonToCatalog;
import edu.mayo.cli.CommandPlugin;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class CreateCatalogCommand
implements CommandPlugin {
    private static final Logger sLogger = Logger.getLogger(CreateCatalogCommand.class);
    private static final char OPTION_INPUT_FILE = 'i';
    private static final char OPTION_OUTPUT_FILE = 'o';
    private static final char OPTION_JSON_COLUMN = 'c';
    private static final char OPTION_NO_SORT = 'n';
    private static final char OPTION_CHROM_SORT_FILE = 'f';
    private static final char OPTION_JSON_ONLY = 'j';
    private static final char OPTION_TEMP_DIR = 't';
    private static final char OPTION_KEEP_CHROM_UNCHANGED = 'k';
    private static final char OPTION_BUILD_ASSEMBLY = 'b';

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        String infile = "";
        String bgzipCatalogOutFile = "";
        if (cl.hasOption('i')) {
            infile = cl.getOptionValue('i');
        }
        if (cl.hasOption('o')) {
            bgzipCatalogOutFile = cl.getOptionValue('o');
            if (!bgzipCatalogOutFile.endsWith(".tsv.bgz")) {
                throw new IllegalArgumentException("Error: Catalog file should end with extension .tsv.bgz");
            }
            if (new File(bgzipCatalogOutFile).exists()) {
                throw new IllegalArgumentException("Error: Output file already exists: " + bgzipCatalogOutFile);
            }
        }
        int jsoncol = -1;
        if (cl.hasOption('c')) {
            jsoncol = new Integer(cl.getOptionValue('c'));
        }
        String chromSortOrderFilePath = null;
        if (cl.hasOption('f')) {
            chromSortOrderFilePath = cl.getOptionValue('f');
        }
        boolean isJsonOnly = cl.hasOption('j');
        boolean isSort = !cl.hasOption('n') && !isJsonOnly;
        String tempDir = TempDirectory.findBaseTempDir("bior_create_catalog_tmp");
        if (cl.hasOption('t')) {
            tempDir = cl.getOptionValue('t');
        }
        HumanBuildAssembly buildAssembly = this.getBuildAssembly(cl);
        boolean isModifyChrom = !cl.hasOption('k');
        boolean isInputFileAlreadyInFinalCtgFormatAndBgzipped = false;
        TjsonToCatalog tjsonToCatalog = new TjsonToCatalog();
        tjsonToCatalog.createCatalog(infile, bgzipCatalogOutFile, isSort, chromSortOrderFilePath, jsoncol, isJsonOnly, tempDir, buildAssembly, isModifyChrom, isInputFileAlreadyInFinalCtgFormatAndBgzipped);
    }

    private HumanBuildAssembly getBuildAssembly(CommandLine cmdLine) throws Exception {
        if (cmdLine.hasOption('b')) {
            String buildOption = cmdLine.getOptionValue('b');
            String errMsg = "Build Assembly not recognized: " + cmdLine.getOptionValue('b') + "\nValid build assemblies:\n";
            for (HumanBuildAssembly build : HumanBuildAssembly.values()) {
                if (buildOption.equalsIgnoreCase(build.toString())) {
                    return build;
                }
                errMsg = errMsg + "  " + build.toString() + "\n";
            }
            sLogger.error((Object)errMsg);
            throw new Exception(errMsg);
        }
        return HumanBuildAssembly.GRCh37;
    }
}

