/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import edu.mayo.bior.catalog.CatalogDataSource;
import edu.mayo.bior.catalog.CatalogFileUtils;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.CatalogTabixEntry;
import edu.mayo.bior.catalog.ChunkUtils;
import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.catalog.verification.CatalogEntryGoldenJson;
import edu.mayo.bior.catalog.verification.CatalogJsonVerifier;
import edu.mayo.bior.catalog.verification.CatalogVariantVerifier;
import edu.mayo.bior.catalog.verification.HumanReferenceInfo;
import edu.mayo.bior.catalog.verification.MessageLogger;
import edu.mayo.bior.catalog.verification.VerifierInputException;
import edu.mayo.bior.catalog.verification.VerifyUtils;
import edu.mayo.pipes.history.ColumnMetaData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CatalogRowVerifier {
    private static final Logger sLogger = Logger.getLogger(CatalogRowVerifier.class);
    private static final long FILE_SIZE_THRESHOLD = 0x140000000L;
    private static final String SPACE = " ";
    public static final String UNKNOWN_CHR = "UNKNOWN";
    private File mCatalogFile;
    private Map<String, ColumnMetaData> mColumnInfo;
    private MessageLogger mLogger;
    private HumanReferenceInfo mReferenceInfo;
    private CatalogJsonVerifier mJsonVerifier;
    private long mOneInXLinesToVerify;
    private long mChunkStartLine = 1L;
    private long mChunkNumLines = Long.MAX_VALUE;
    private long rowsInCatalog = 0L;
    private long rowsVerified = 0L;

    public CatalogRowVerifier(File catalogFile, CatalogDataSource dataSource, Map<String, ColumnMetaData> catalogColumns, MessageLogger logger, long oneInXLinesToVerify) throws VerifierInputException {
        this(catalogFile, dataSource, catalogColumns, logger, oneInXLinesToVerify, 1L, Long.MAX_VALUE);
    }

    public CatalogRowVerifier(File catalogFile, CatalogDataSource dataSource, Map<String, ColumnMetaData> catalogColumns, MessageLogger logger, long oneInXLinesToVerify, long startLine, long numLines) throws VerifierInputException {
        this.mCatalogFile = catalogFile;
        this.mColumnInfo = catalogColumns;
        this.mLogger = logger;
        this.mJsonVerifier = new CatalogJsonVerifier(catalogColumns, logger);
        HumanBuildAssembly humanBuildAssembly = dataSource == null ? null : dataSource.getHumanBuildAssembly();
        this.mReferenceInfo = new HumanReferenceInfo(humanBuildAssembly, logger);
        this.mOneInXLinesToVerify = oneInXLinesToVerify;
        this.mChunkStartLine = startLine;
        this.mChunkNumLines = numLines;
    }

    protected void _test_setCatalogJsonVerifier(CatalogJsonVerifier verifier) {
        this.mJsonVerifier = verifier;
    }

    protected void _test_setChunk(long chunkStartLine, long chunkNumLines) {
        this.mChunkStartLine = chunkStartLine;
        this.mChunkNumLines = chunkNumLines;
    }

    protected void _test_setRowCounts(long rowsInCtg, long rowsVerified) {
        this.rowsInCatalog = rowsInCtg;
        this.rowsVerified = rowsVerified;
    }

    public void reportColumnUsage() {
        if (!this.haveColumnInfo()) {
            this.logWarning("Cannot report usage stats as we have no information from columns.tsv. ");
            return;
        }
        for (String colName : this.mColumnInfo.keySet()) {
            ColumnMetaData catCol = this.mColumnInfo.get(colName);
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append(String.format("Column '%s'", colName));
            long numTimesInCatalog = this.mJsonVerifier.getNumberOfTimesKeySeenInCatalog(colName);
            if (numTimesInCatalog == 0L) {
                msgBuf.append(" not found in the catalog. Consider removing it from the columns.tsv file.");
                this.logWarning(msgBuf.toString());
                continue;
            }
            msgBuf.append(String.format(": number of occurrences in catalog: %d.", numTimesInCatalog));
            if (catCol.getCount().equals(".")) {
                msgBuf.append(String.format(" Largest number of elements found for array column: %d.", this.mJsonVerifier.getMaxValuesForKey(colName)));
            }
            this.logInfo(msgBuf.toString());
        }
    }

    public void verify() {
        CatalogVariantVerifier variantVerifier = null;
        this.logSamplingAndChunkSizeStats();
        BufferedReader catalogRdr = CatalogFileUtils.getBufferedReader(this.mCatalogFile.getAbsolutePath());
        if (catalogRdr == null) {
            this.logCannotReadCatalogError();
            return;
        }
        boolean fileBiggerThanThreshold = false;
        if (this.mCatalogFile.length() > 0x140000000L) {
            fileBiggerThanThreshold = true;
            sLogger.debug((Object)String.format("Catalog file length %d > %d. Can stop reading early if past chunk.", this.mCatalogFile.length(), 0x140000000L));
        }
        String chrProcessing = null;
        try {
            String curCatalogRow;
            boolean seen4TabixColumns = false;
            boolean seen1TabixColumn = false;
            boolean keepChecking = true;
            catalogRdr = CatalogFileUtils.getBufferedReader(this.mCatalogFile.getAbsolutePath());
            boolean stoppedReading = false;
            while ((curCatalogRow = catalogRdr.readLine()) != null && keepChecking) {
                if (curCatalogRow.trim().startsWith("#")) continue;
                if (fileBiggerThanThreshold && ChunkUtils.beyondTargetChunk(this.rowsInCatalog + 1L, this.mChunkStartLine, this.mChunkNumLines)) {
                    stoppedReading = true;
                    sLogger.info((Object)String.format("Stopped reading catalog after reading %d lines - past chunk", this.rowsInCatalog));
                    break;
                }
                this.logMemoryUseAndRowCountSoFar(this.rowsInCatalog, this.rowsVerified);
                ++this.rowsInCatalog;
                if (this.shouldSkipRow(this.rowsInCatalog)) continue;
                ++this.rowsVerified;
                CatalogTabixEntry currentRow = VerifyUtils.readCatalogRow(curCatalogRow, this.mLogger);
                if (currentRow == null) continue;
                if (currentRow.is4Field()) {
                    seen4TabixColumns = true;
                } else if (currentRow.is1Field()) {
                    seen1TabixColumn = true;
                }
                if (seen4TabixColumns && seen1TabixColumn) {
                    this.logError("Saw a mix of 4 columns and 1 columns in catalog. Stopping checking", 201);
                    keepChecking = false;
                    continue;
                }
                if (chrProcessing == null || !currentRow.getChromosome().equals(chrProcessing)) {
                    this.logRefAlleleNotMatchingSummary(variantVerifier, chrProcessing);
                    chrProcessing = currentRow.getChromosome();
                    variantVerifier = new CatalogVariantVerifier(this.mReferenceInfo, chrProcessing, this.mLogger);
                }
                this.verifyCatalogRow(currentRow, variantVerifier);
            }
            this.logEndResults(variantVerifier, chrProcessing, this.rowsInCatalog, this.rowsVerified, stoppedReading);
        }
        catch (IOException e) {
            this.logError("Problem in catalog verify: " + e.getMessage(), 3);
        }
    }

    private void logCannotReadCatalogError() {
        String msg = String.format("Couldn't read catalog '%s' for unknown reason", this.mCatalogFile.getPath());
        this.logError(msg, 1);
        this.logError("Won't be able to run row-by-row verify. Check logs for more detail.", 2);
    }

    private void logSamplingAndChunkSizeStats() {
        String samplingStr = this.mOneInXLinesToVerify == 1L ? "each row" : "1 in " + this.mOneInXLinesToVerify + " rows";
        String statusMsg = String.format("Verifying %s for '%s' starting at %s", samplingStr, this.mCatalogFile.getPath(), VerifyUtils.composeDateTime());
        System.out.println(statusMsg);
        this.logInfo(statusMsg);
        String endChunkPosition = this.mChunkNumLines == 0L || this.mChunkNumLines == Long.MAX_VALUE ? "END" : this.mChunkNumLines + "";
        String chunkStr = "Chunk (lines): " + this.mChunkStartLine + " - " + endChunkPosition;
        this.logInfo(chunkStr);
    }

    private void logEndResults(CatalogVariantVerifier variantVerifier, String chrProcessing, long rowsInCatalog, long rowsVerified, boolean stoppedReading) {
        this.logMemoryUseAndRowCountSoFarForcePrint(rowsInCatalog, rowsVerified);
        this.logRefAlleleNotMatchingSummary(variantVerifier, chrProcessing);
        String statusMsg = String.format("Verified %d of total %d rows of catalog, finished at %s.", rowsVerified, rowsInCatalog, VerifyUtils.composeDateTime());
        if (stoppedReading) {
            statusMsg = String.format("Verified %d of total ??? rows of catalog (read %d rows and stopped reading after chunk due to large catalog size), finished at %s.", rowsVerified, rowsInCatalog, VerifyUtils.composeDateTime());
        }
        System.out.println(statusMsg);
        this.logInfo(statusMsg);
    }

    private boolean shouldSkipRow(long currentRowInCatalog) {
        if (!ChunkUtils.inTargetChunk(currentRowInCatalog, this.mChunkStartLine, this.mChunkNumLines)) {
            return true;
        }
        long zeroBasedRowInCatalog = currentRowInCatalog - 1L;
        boolean isOneInXRowToSample = zeroBasedRowInCatalog % this.mOneInXLinesToVerify == 0L;
        return !isOneInXRowToSample;
    }

    private void logMemoryUseAndRowCountSoFar(long rowsCountedInCatalogSoFar, long rowsVerified) {
        if (rowsCountedInCatalogSoFar % 100000L == 0L) {
            this.logMemoryUseAndRowCountSoFarForcePrint(rowsCountedInCatalogSoFar, rowsVerified);
        }
    }

    private void logMemoryUseAndRowCountSoFarForcePrint(long rowsCountedInCatalogSoFar, long rowsVerified) {
        if (rowsCountedInCatalogSoFar == 0L) {
            return;
        }
        System.gc();
        sLogger.info((Object)("Rows counted: " + rowsCountedInCatalogSoFar + ".  Rows verified: " + rowsVerified));
        System.gc();
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() / 1024L) / 1024.0 - (double)(Runtime.getRuntime().freeMemory() / 1024L) / 1024.0;
        sLogger.debug((Object)("Memory used currently: " + currentMemory + " MB at " + rowsCountedInCatalogSoFar + " rows processed"));
    }

    private void logRefAlleleNotMatchingSummary(CatalogVariantVerifier variantVerifier, String chrProcessing) {
        if (chrProcessing != null && variantVerifier != null && variantVerifier.getNumberRefAllelesNotMatchReferenceSequence() != 0L) {
            int code = 504;
            if (VerifyUtils.isChrM(chrProcessing)) {
                code = 505;
            }
            String noMatchMessage = "Chromosome " + chrProcessing + ": _refAllele values that DO NOT match the reference sequence is [" + variantVerifier.getNumberRefAllelesNotMatchReferenceSequence() + "].";
            this.logError(noMatchMessage, code);
        }
    }

    private void verifyCatalogRow(CatalogTabixEntry catalogRowEntry, CatalogVariantVerifier variantVerifier) throws NumberFormatException, IOException {
        JsonObject catalogRowJsonObj;
        try {
            catalogRowJsonObj = VerifyUtils.getJsonObject(catalogRowEntry.getJsonString());
        }
        catch (JsonParseException jse) {
            this.logError("Exception parsing json value for tabix row =" + catalogRowEntry.getJsonString(), 414);
            return;
        }
        this.verifyRowTabix(catalogRowEntry);
        this.mJsonVerifier.verify(catalogRowEntry.getJsonString());
        CatalogEntryGoldenJson catalogRowGolden = this.verifyRowGoldenJson(catalogRowJsonObj, catalogRowEntry);
        if (catalogRowGolden == null) {
            return;
        }
        this.verifyTabixToGoldenElements(catalogRowEntry, catalogRowGolden);
        variantVerifier.verify(catalogRowJsonObj, catalogRowGolden);
    }

    protected void verifyRowTabix(CatalogTabixEntry tabixEntry) {
        if (tabixEntry.is4Field() && this.mReferenceInfo.canCheck()) {
            this.verifyTabixPositionsInChrRange(tabixEntry);
        }
    }

    protected CatalogEntryGoldenJson verifyRowGoldenJson(JsonObject catalogRowJson, CatalogTabixEntry catalogRowEntry) {
        CatalogEntryGoldenJson catalogRowGolden;
        try {
            catalogRowGolden = new CatalogEntryGoldenJson(catalogRowJson);
        }
        catch (CatalogFormatException e) {
            this.logError(e.getMessage(), 4);
            return null;
        }
        if (catalogRowEntry.is1Field()) {
            return catalogRowGolden;
        }
        Set<String> validChrs = null;
        if (this.mReferenceInfo.getChrSizeMap() != null && this.mReferenceInfo.getChrSizeMap().size() > 0) {
            validChrs = this.mReferenceInfo.getChrSizeMap().keySet();
        }
        this.verifyGoldenJsonLandmark(catalogRowGolden, catalogRowJson, validChrs);
        this.verifyGoldenJsonBp(catalogRowGolden.getMinBP(), catalogRowJson, "_minBP", 207);
        this.verifyGoldenJsonBp(catalogRowGolden.getMaxBP(), catalogRowJson, "_maxBP", 208);
        return catalogRowGolden;
    }

    private void verifyGoldenJsonLandmark(CatalogEntryGoldenJson catalogRowGolden, JsonObject catalogRowJson, Set<String> validChrValues) {
        String chr = catalogRowGolden.getChr();
        if (chr == null) {
            this.logWarning("_landmark golden value is not in JSON String, but entry is positional. Json: " + catalogRowJson.toString());
            return;
        }
        if (UNKNOWN_CHR.equals(chr)) {
            return;
        }
        if (validChrValues != null && validChrValues.size() > 0 && !validChrValues.contains(chr)) {
            this.logWarning("_landmark value [" + chr + "] not found in configured valid chromosomes list: " + validChrValues.toString());
        }
        if (!chr.equals("X") && !chr.equals("Y") && !chr.equals("M") && chr.matches("\\d+")) {
            try {
                Integer iLandmark = new Integer(chr);
                if (iLandmark < 1 || iLandmark > 22) {
                    this.logError("_landmark value should be between 1 and 22 [" + chr + "], but is not. Json: " + catalogRowJson.toString(), 303);
                }
            }
            catch (Exception e) {
                this.logError("_landmark value should be valid numeric chr value at this point [" + chr + "], but could not create Integer object for value. Json : " + catalogRowJson.toString(), 304);
            }
        }
    }

    private boolean haveColumnInfo() {
        return this.mColumnInfo != null && this.mColumnInfo.size() > 0;
    }

    private void verifyGoldenJsonBp(Long bp, JsonObject catalogRowJson, String key, int errorCode) {
        if (bp == null) {
            this.logError(String.format("%s should be set. Json '%s'", key, catalogRowJson.toString()), errorCode);
        }
    }

    protected void verifyTabixToGoldenElements(CatalogTabixEntry tabixRowEntry, CatalogEntryGoldenJson goldenVariant) {
        String msg;
        Long jsonGoldenIntMaxBP;
        Long jsonGoldenIntMinBP;
        if (tabixRowEntry.is1Field()) {
            return;
        }
        String jsonLandmarkChr = goldenVariant.getChr();
        if (!tabixRowEntry.getChromosome().equals(jsonLandmarkChr)) {
            String msg2 = String.format("Tabix chr [%s] not same as _landmark value [%s].  Row: %s", tabixRowEntry.getChromosome(), jsonLandmarkChr, this.getFirstXChars(tabixRowEntry.getLine(), 100));
            this.logError(msg2, 209);
        }
        if ((jsonGoldenIntMinBP = goldenVariant.getMinBP()) != null && tabixRowEntry.getMinPosition().intValue() != jsonGoldenIntMinBP.intValue()) {
            String msg3 = String.format("Tabix start position [%d] not same as _minBP value [%d].  Row: %s", tabixRowEntry.getMinPosition(), jsonGoldenIntMinBP, this.getFirstXChars(tabixRowEntry.getLine(), 100));
            this.logError(msg3, 210);
        }
        if ((jsonGoldenIntMaxBP = goldenVariant.getMaxBP()) != null && tabixRowEntry.getMaxPosition().intValue() != jsonGoldenIntMaxBP.intValue()) {
            msg = String.format("Tabix stop position [%d] not same as _maxBP value [%d].  Row: %s", tabixRowEntry.getMaxPosition(), jsonGoldenIntMaxBP, this.getFirstXChars(tabixRowEntry.getLine(), 100));
            this.logError(msg, 211);
        }
        if (tabixRowEntry.getMaxPosition() < tabixRowEntry.getMinPosition()) {
            msg = String.format("Tabix stop position [%d] less than tabix start position [%d]. Invalid catalog format.  Row: %s", tabixRowEntry.getMaxPosition(), tabixRowEntry.getMinPosition(), this.getFirstXChars(tabixRowEntry.getLine(), 100));
            this.logError(msg, 212);
        }
        if (jsonGoldenIntMinBP != null && jsonGoldenIntMaxBP != null && jsonGoldenIntMaxBP < jsonGoldenIntMinBP) {
            msg = String.format("Golden _maxBP stop position [%d] less than golden _minBP start value [%d].  Invalid catalog format.  Row: %s", jsonGoldenIntMaxBP, jsonGoldenIntMinBP, this.getFirstXChars(tabixRowEntry.getLine(), 100));
            this.logError(msg, 213);
        }
    }

    private Object getFirstXChars(String line, int numChars) {
        if (line == null) {
            return "(null)";
        }
        if (line.length() <= numChars) {
            return line;
        }
        return line.substring(0, numChars) + "...";
    }

    private void verifyTabixPositionsInChrRange(CatalogTabixEntry tabixEntry) {
        if (tabixEntry.isValidNonPositional()) {
            return;
        }
        if (!tabixEntry.isPositional()) {
            this.logError("Tabix entry is neither positional or non-positional.  Chr: " + tabixEntry.getChromosome() + " Tabix entry min position: " + tabixEntry.getMinPosition() + " Tabix entry max position: " + tabixEntry.getMaxPosition(), 214);
            return;
        }
        if (!this.inChromosomeRange(tabixEntry.getChromosome(), tabixEntry.getMinPosition())) {
            this.logError("Tabix start position not in valid chromosome size range.  Chr: " + tabixEntry.getChromosome() + " Chr Max Position: " + this.mReferenceInfo.getChrSizeMap().get(tabixEntry.getChromosome()) + " Tabix entry min position: " + tabixEntry.getMinPosition(), 215);
        }
        if (!this.inChromosomeRange(tabixEntry.getChromosome(), tabixEntry.getMaxPosition())) {
            this.logError("Tabix stop position not in valid chromosome size range.  Chr: " + tabixEntry.getChromosome() + " Chr Max Position: " + this.mReferenceInfo.getChrSizeMap().get(tabixEntry.getChromosome()) + " Tabix entry min position: " + tabixEntry.getMaxPosition(), 216);
        }
    }

    private boolean inChromosomeRange(String chr, long pos) {
        Long chrSize = this.mReferenceInfo.getChrSizeMap().get(chr);
        if (VerifyUtils.isEmpty(chr)) {
            this.logError("Chromosome value is empty. Cannot check position [" + pos + "] for chromosome value.", 305);
            return false;
        }
        if (chrSize == null) {
            this.logError("Chromosome value not found in chromosome size map: " + chr + " Cannot check position [" + pos + "] for chromosome value.", 306);
            return false;
        }
        return pos >= 1L && pos <= chrSize;
    }

    private void logInfo(String msg) {
        this.mLogger.logInfo(msg);
    }

    private void logWarning(String msg) {
        this.mLogger.logWarning(msg);
    }

    private void logError(String msg, int code) {
        this.mLogger.logError(msg, code);
    }
}

