/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.refassembly;

import java.io.File;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSorterByChromosome
implements Comparator<File> {
    private String mFilePrefixToDisregard = "";

    public FileSorterByChromosome() {
    }

    public FileSorterByChromosome(String filePrefixToDisregard) {
        this.mFilePrefixToDisregard = filePrefixToDisregard;
    }

    @Override
    public int compare(File file1, File file2) {
        StringBuilder filename1 = new StringBuilder(file1.getName());
        StringBuilder filename2 = new StringBuilder(file2.getName());
        if (this.mFilePrefixToDisregard.length() > 0) {
            filename1 = new StringBuilder(filename1.toString().replaceAll("^" + this.mFilePrefixToDisregard, ""));
            filename2 = new StringBuilder(filename2.toString().replaceAll("^" + this.mFilePrefixToDisregard, ""));
        } else {
            while (filename1.charAt(0) == filename2.charAt(0) && !this.isNumOrMXY(filename2.charAt(0))) {
                filename1.deleteCharAt(0);
                filename2.deleteCharAt(0);
            }
        }
        Integer rank1 = this.getChromRank(filename1.toString());
        Integer rank2 = this.getChromRank(filename2.toString());
        if (rank1.compareTo(rank2) == 0) {
            return filename1.toString().compareToIgnoreCase(filename2.toString());
        }
        return rank1.compareTo(rank2);
    }

    private boolean isNumOrMXY(char chr) {
        return Character.isDigit(chr) || chr == 'M' || chr == 'X' || chr == 'Y';
    }

    public int getChromRank(String filename) {
        if (filename.startsWith("M") || filename.startsWith("26")) {
            return 26;
        }
        if (filename.startsWith("XY") || filename.startsWith("25")) {
            return 25;
        }
        if (filename.startsWith("Y")) {
            return 24;
        }
        if (filename.startsWith("X") || filename.startsWith("23")) {
            return 23;
        }
        if (filename.startsWith("22")) {
            return 22;
        }
        if (filename.startsWith("21")) {
            return 21;
        }
        if (filename.startsWith("20")) {
            return 20;
        }
        if (filename.startsWith("19")) {
            return 19;
        }
        if (filename.startsWith("18")) {
            return 18;
        }
        if (filename.startsWith("17")) {
            return 17;
        }
        if (filename.startsWith("16")) {
            return 16;
        }
        if (filename.startsWith("15")) {
            return 15;
        }
        if (filename.startsWith("14")) {
            return 14;
        }
        if (filename.startsWith("13")) {
            return 13;
        }
        if (filename.startsWith("12")) {
            return 12;
        }
        if (filename.startsWith("11")) {
            return 11;
        }
        if (filename.startsWith("10")) {
            return 10;
        }
        if (filename.startsWith("9")) {
            return 9;
        }
        if (filename.startsWith("8")) {
            return 8;
        }
        if (filename.startsWith("7")) {
            return 7;
        }
        if (filename.startsWith("6")) {
            return 6;
        }
        if (filename.startsWith("5")) {
            return 5;
        }
        if (filename.startsWith("4")) {
            return 4;
        }
        if (filename.startsWith("3")) {
            return 3;
        }
        if (filename.startsWith("2")) {
            return 2;
        }
        if (filename.startsWith("1")) {
            return 1;
        }
        return 30;
    }
}

