/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import edu.mayo.pipes.bioinformatics.HeaderFieldDefinition;
import edu.mayo.pipes.bioinformatics.HeaderFieldDefinitionHelpers;
import edu.mayo.pipes.bioinformatics.KeyValueHeaderPair;
import edu.mayo.pipes.bioinformatics.VCFParseException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;

public class FormatHeader
extends HeaderFieldDefinition {
    public FormatHeader() {
        this.fieldType = "FORMAT";
        this.requiredFields = Arrays.asList("ID", "Type", "Number", "Description");
    }

    public void createFromString(String formatHeaderLine) throws VCFParseException, UnsupportedEncodingException {
        this.originalLine = formatHeaderLine;
        this.verifyLine(formatHeaderLine);
        String PREFIX = "##" + this.fieldType + "=<";
        formatHeaderLine = formatHeaderLine.substring(PREFIX.length(), formatHeaderLine.length() - 1);
        Map<String, KeyValueHeaderPair> keyValPairMap = HeaderFieldDefinitionHelpers.getKeyValuePairsFromString(formatHeaderLine);
        this.id = this.getFirstVal(keyValPairMap.get("ID"));
        this.type = HeaderFieldDefinitionHelpers.parseType(this.getFirstVal(keyValPairMap.get("Type")));
        this.number = HeaderFieldDefinitionHelpers.parseNumber(this.getFirstVal(keyValPairMap.get("Number")), this.type);
        this.desc = this.stripQuotesAndUnescape(this.getFirstVal(keyValPairMap.get("Description")), true);
    }

    private void verifyLine(String metaHeaderLine) {
        if (!metaHeaderLine.startsWith("##" + this.fieldType + "=<") && !metaHeaderLine.endsWith(">")) {
            throw new IllegalArgumentException("Invalid ##" + this.fieldType + " line.  Format should be: ##" + this.fieldType + "=<....>\n" + "Example:  ##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">");
        }
        for (String requiredField : this.requiredFields) {
            if (metaHeaderLine.contains("<" + requiredField + "=") || metaHeaderLine.contains("," + requiredField + "=")) continue;
            throw new IllegalArgumentException("Invalid ##" + this.fieldType + " line.  These fields are required: " + this.requiredFields.toString());
        }
    }
}

