/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.inject.ColumnAware;
import edu.mayo.pipes.JSON.inject.ColumnInjector;
import edu.mayo.pipes.JSON.inject.Injector;
import edu.mayo.pipes.JSON.modify.JsonTypeExtended;
import edu.mayo.pipes.history.History;
import java.util.NoSuchElementException;

public class InjectIntoJsonPipe
extends AbstractPipe<History, History> {
    private int mIdxJsonCol;
    boolean mIsFirst = true;
    private Injector[] mInjectors;
    private JsonParser mParser = new JsonParser();
    private boolean mIsCreateNewJsonColumn = false;

    public InjectIntoJsonPipe(int indexOfJsonColumn, Injector ... injectors) {
        if (this.isJsonIdxSameAsAnother(indexOfJsonColumn, injectors)) {
            throw new IllegalArgumentException("JSON column index cannot be the same as another column index");
        }
        if (indexOfJsonColumn == 0) {
            throw new IllegalArgumentException("Zero is not a valid column - columns begin with 1.");
        }
        this.mIdxJsonCol = indexOfJsonColumn;
        this.mInjectors = injectors;
    }

    public InjectIntoJsonPipe(boolean isCreateNewJsonColumn, Injector ... injectors) {
        this.mIdxJsonCol = -1;
        this.mIsCreateNewJsonColumn = isCreateNewJsonColumn;
        this.mInjectors = injectors;
    }

    public InjectIntoJsonPipe(Injector ... injectors) {
        this(false, injectors);
    }

    public InjectIntoJsonPipe(String ... columnNames) {
        this(false, InjectIntoJsonPipe.createStringColumnInjectors(columnNames));
    }

    public InjectIntoJsonPipe(boolean isCreateNewJsonColumn, String ... columnNames) {
        this(isCreateNewJsonColumn, InjectIntoJsonPipe.createStringColumnInjectors(columnNames));
    }

    protected History processNextStart() throws NoSuchElementException {
        History historyOut = this.getNextNonBlankLine();
        this.addEmptyJsonObjectToLastColumnAsNeeded(historyOut);
        return this.injectAllValues(historyOut);
    }

    private History injectAllValues(History historyOut) {
        String json = (String)historyOut.get(this.mIdxJsonCol - 1);
        if (!this.isAJsonColumn(json)) {
            throw new IllegalArgumentException("The JSON column to inject into does not contain a JSON object or valid JSON");
        }
        JsonObject object = this.mParser.parse(json).getAsJsonObject();
        for (Injector injector : this.mInjectors) {
            injector.inject(object, historyOut);
        }
        historyOut.set(this.mIdxJsonCol - 1, object.toString());
        return historyOut;
    }

    private void addEmptyJsonObjectToLastColumnAsNeeded(History historyOut) {
        if (this.mIsCreateNewJsonColumn || this.mIdxJsonCol > historyOut.size()) {
            this.mIdxJsonCol = historyOut.size() + 1;
            historyOut.add("{}");
            if (this.mIsFirst) {
                this.mIsFirst = false;
            }
        } else if (this.mIdxJsonCol == -1) {
            this.mIdxJsonCol = historyOut.size();
        }
    }

    private History getNextNonBlankLine() {
        History hist = (History)this.starts.next();
        while (hist == null || hist.size() == 1 && ((String)hist.get(0)).trim().length() == 0) {
            hist = (History)this.starts.next();
        }
        return hist;
    }

    private boolean isAJsonColumn(String json) {
        return json.startsWith("{") && json.endsWith("}");
    }

    private boolean isJsonIdxSameAsAnother(int indexOfJsonColumn, Injector[] injectors) {
        for (Injector injector : injectors) {
            if (!(injector instanceof ColumnAware) || indexOfJsonColumn != ((ColumnAware)((Object)injector)).getColumn()) continue;
            return true;
        }
        return false;
    }

    private static Injector[] createStringColumnInjectors(String[] columnNames) {
        Injector[] injectors = new ColumnInjector[columnNames.length];
        for (int i = 0; i < injectors.length; ++i) {
            injectors[i] = new ColumnInjector(i + 1, columnNames[i], JsonTypeExtended.STRING);
        }
        return injectors;
    }
}

