/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.DuplicateReadFilter;
import htsjdk.samtools.filter.FilteringIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SecondaryOrSupplementaryFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.Locus;
import htsjdk.samtools.util.LocusComparator;
import htsjdk.samtools.util.LocusImpl;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ReferenceSequenceMask;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import htsjdk.samtools.util.WholeGenomeReferenceSequenceMask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SamLocusIterator
implements Iterable<LocusInfo>,
CloseableIterator<LocusInfo> {
    private static final Log LOG = Log.getInstance(SamLocusIterator.class);
    private final SamReader samReader;
    private final ReferenceSequenceMask referenceSequenceMask;
    private PeekableIterator<SAMRecord> samIterator;
    private List<SamRecordFilter> samFilters = Arrays.asList(new SecondaryOrSupplementaryFilter(), new DuplicateReadFilter());
    private final List<Interval> intervals;
    private final boolean useIndex;
    private final ArrayList<LocusInfo> complete = new ArrayList(100);
    private final ArrayList<LocusInfo> accumulator = new ArrayList(100);
    private int qualityScoreCutoff = Integer.MIN_VALUE;
    private int mappingQualityScoreCutoff = Integer.MIN_VALUE;
    private boolean includeNonPfReads = true;
    private boolean emitUncoveredLoci = true;
    private int lastReferenceSequence = 0;
    private int lastPosition = 0;
    private boolean finishedAlignedReads = false;
    private final LocusComparator<Locus> locusComparator = new LocusComparator();

    public SamLocusIterator(SamReader samReader) {
        this(samReader, null);
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList) {
        this(samReader, intervalList, samReader.hasIndex());
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList, boolean bl) {
        if (samReader.getFileHeader().getSortOrder() == null || samReader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.unsorted) {
            LOG.warn("SamLocusIterator constructed with samReader that has SortOrder == unsorted.  ", "Assuming SAM is coordinate sorted, but exceptions may occur if it is not.");
        } else if (samReader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException("SamLocusIterator cannot operate on a SAM file that is not coordinate sorted.");
        }
        this.samReader = samReader;
        this.useIndex = bl;
        if (intervalList != null) {
            this.intervals = intervalList.uniqued().getIntervals();
            this.referenceSequenceMask = new IntervalListReferenceSequenceMask(intervalList);
        } else {
            this.intervals = null;
            this.referenceSequenceMask = new WholeGenomeReferenceSequenceMask(samReader.getFileHeader());
        }
    }

    @Override
    public Iterator<LocusInfo> iterator() {
        if (this.samIterator != null) {
            throw new IllegalStateException("Cannot call iterator() more than once on SamLocusIterator");
        }
        CloseableIterator<SAMRecord> closeableIterator = this.intervals != null ? new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(this.samReader, this.intervals, this.useIndex) : this.samReader.iterator();
        if (this.samFilters != null) {
            closeableIterator = new FilteringIterator(closeableIterator, new AggregateFilter(this.samFilters));
        }
        this.samIterator = new PeekableIterator<SAMRecord>(closeableIterator);
        return this;
    }

    @Override
    public void close() {
        this.samIterator.close();
    }

    private boolean samHasMore() {
        return !this.finishedAlignedReads && this.samIterator.peek() != null;
    }

    @Override
    public boolean hasNext() {
        if (this.samIterator == null) {
            this.iterator();
        }
        while (this.complete.isEmpty() && (!this.accumulator.isEmpty() || this.samHasMore() || this.hasRemainingMaskBases())) {
            LocusInfo locusInfo = this.next();
            if (locusInfo == null) continue;
            this.complete.add(0, locusInfo);
        }
        return !this.complete.isEmpty();
    }

    private boolean hasRemainingMaskBases() {
        if (!this.emitUncoveredLoci) {
            return false;
        }
        return this.lastReferenceSequence < this.referenceSequenceMask.getMaxSequenceIndex() || this.lastReferenceSequence == this.referenceSequenceMask.getMaxSequenceIndex() && this.lastPosition < this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
    }

    @Override
    public LocusInfo next() {
        LocusImpl locusImpl;
        Object object;
        while (this.complete.isEmpty() && this.samHasMore()) {
            object = this.samIterator.peek();
            if (((SAMRecord)object).getReferenceIndex() == -1) {
                this.finishedAlignedReads = true;
                continue;
            }
            if (((SAMRecord)object).getReadUnmappedFlag() || ((SAMRecord)object).getMappingQuality() < this.mappingQualityScoreCutoff || !this.includeNonPfReads && ((SAMRecord)object).getReadFailsVendorQualityCheckFlag()) {
                this.samIterator.next();
                continue;
            }
            locusImpl = new LocusImpl(((SAMRecord)object).getReferenceIndex(), ((SAMRecord)object).getAlignmentStart());
            while (!this.accumulator.isEmpty() && this.locusComparator.compare(this.accumulator.get(0), locusImpl) < 0) {
                LocusInfo locusInfo = this.accumulator.get(0);
                this.populateCompleteQueue(locusImpl);
                if (!this.complete.isEmpty()) {
                    return this.complete.remove(0);
                }
                if (this.accumulator.isEmpty() || locusInfo != this.accumulator.get(0)) continue;
                throw new SAMException("Stuck in infinite loop");
            }
            if (!(this.accumulator.isEmpty() || this.accumulator.get(0).getSequenceIndex() == ((SAMRecord)object).getReferenceIndex().intValue() && this.accumulator.get(0).position == ((SAMRecord)object).getAlignmentStart())) {
                throw new IllegalStateException("accumulator should be empty or aligned with current SAMRecord");
            }
            this.accumulateSamRecord((SAMRecord)object);
            this.samIterator.next();
        }
        object = new LocusImpl(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (this.complete.isEmpty() && !this.samHasMore()) {
            while (!this.accumulator.isEmpty()) {
                this.populateCompleteQueue((Locus)object);
                if (this.complete.isEmpty()) continue;
                return this.complete.remove(0);
            }
        }
        if (!this.complete.isEmpty()) {
            return this.complete.remove(0);
        }
        if (this.emitUncoveredLoci) {
            locusImpl = new LocusImpl(this.referenceSequenceMask.getMaxSequenceIndex(), this.referenceSequenceMask.getMaxPosition() + 1);
            return this.createNextUncoveredLocusInfo(locusImpl);
        }
        return null;
    }

    private void accumulateSamRecord(SAMRecord sAMRecord) {
        int n;
        SAMSequenceRecord sAMSequenceRecord = this.getReferenceSequence(sAMRecord.getReferenceIndex());
        int n2 = sAMRecord.getAlignmentStart();
        int n3 = sAMRecord.getAlignmentEnd();
        int n4 = n3 - n2;
        for (n = this.accumulator.size(); n <= n4; ++n) {
            this.accumulator.add(new LocusInfo(sAMSequenceRecord, n2 + n));
        }
        n = this.getQualityScoreCutoff();
        boolean bl = n == 0;
        byte[] byArray = bl ? null : sAMRecord.getBaseQualities();
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            int n5 = alignmentBlock.getReadStart();
            int n6 = alignmentBlock.getReferenceStart();
            int n7 = alignmentBlock.getLength();
            for (int i = 0; i < n7; ++i) {
                int n8 = n5 + i - 1;
                int n9 = n6 + i - n2;
                if (!bl && byArray[n8] < n) continue;
                this.accumulator.get(n9).add(sAMRecord, n8);
            }
        }
    }

    private LocusInfo createNextUncoveredLocusInfo(Locus locus) {
        while (this.lastReferenceSequence <= locus.getSequenceIndex() && this.lastReferenceSequence <= this.referenceSequenceMask.getMaxSequenceIndex()) {
            if (this.lastReferenceSequence == locus.getSequenceIndex() && this.lastPosition + 1 >= locus.getPosition()) {
                return null;
            }
            int n = this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
            if (n == -1) {
                if (this.lastReferenceSequence == locus.getSequenceIndex()) {
                    this.lastPosition = locus.getPosition();
                    return null;
                }
                ++this.lastReferenceSequence;
                this.lastPosition = 0;
                continue;
            }
            if (this.lastReferenceSequence < locus.getSequenceIndex() || n < locus.getPosition()) {
                this.lastPosition = n;
                return new LocusInfo(this.getReferenceSequence(this.lastReferenceSequence), this.lastPosition);
            }
            if (n < locus.getPosition()) continue;
            return null;
        }
        return null;
    }

    private void populateCompleteQueue(Locus locus) {
        LocusInfo locusInfo;
        while (!this.accumulator.isEmpty() && this.accumulator.get(0).getRecordAndPositions().isEmpty() && this.locusComparator.compare(this.accumulator.get(0), locus) < 0) {
            this.accumulator.remove(0);
        }
        if (this.accumulator.isEmpty()) {
            return;
        }
        LocusInfo locusInfo2 = this.accumulator.get(0);
        if (this.locusComparator.compare(locus, locusInfo2) <= 0) {
            return;
        }
        if (this.emitUncoveredLoci && (locusInfo = this.createNextUncoveredLocusInfo(locusInfo2)) != null) {
            this.complete.add(locusInfo);
            return;
        }
        this.accumulator.remove(0);
        int n = locusInfo2.getSequenceIndex();
        if (this.referenceSequenceMask.get(locusInfo2.getSequenceIndex(), locusInfo2.getPosition())) {
            this.complete.add(locusInfo2);
        }
        this.lastReferenceSequence = n;
        this.lastPosition = locusInfo2.getPosition();
    }

    private SAMSequenceRecord getReferenceSequence(int n) {
        return this.samReader.getFileHeader().getSequence(n);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    public void setSamFilters(List<SamRecordFilter> list) {
        this.samFilters = list;
    }

    public int getQualityScoreCutoff() {
        return this.qualityScoreCutoff;
    }

    public void setQualityScoreCutoff(int n) {
        this.qualityScoreCutoff = n;
    }

    public int getMappingQualityScoreCutoff() {
        return this.mappingQualityScoreCutoff;
    }

    public void setMappingQualityScoreCutoff(int n) {
        this.mappingQualityScoreCutoff = n;
    }

    public boolean isIncludeNonPfReads() {
        return this.includeNonPfReads;
    }

    public void setIncludeNonPfReads(boolean bl) {
        this.includeNonPfReads = bl;
    }

    public boolean isEmitUncoveredLoci() {
        return this.emitUncoveredLoci;
    }

    public void setEmitUncoveredLoci(boolean bl) {
        this.emitUncoveredLoci = bl;
    }

    public static final class LocusInfo
    implements Locus {
        private final SAMSequenceRecord referenceSequence;
        private final int position;
        private final List<RecordAndOffset> recordAndOffsets = new ArrayList<RecordAndOffset>(100);

        LocusInfo(SAMSequenceRecord sAMSequenceRecord, int n) {
            this.referenceSequence = sAMSequenceRecord;
            this.position = n;
        }

        public void add(SAMRecord sAMRecord, int n) {
            this.recordAndOffsets.add(new RecordAndOffset(sAMRecord, n));
        }

        @Override
        public int getSequenceIndex() {
            return this.referenceSequence.getSequenceIndex();
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        public List<RecordAndOffset> getRecordAndPositions() {
            return Collections.unmodifiableList(this.recordAndOffsets);
        }

        public String getSequenceName() {
            return this.referenceSequence.getSequenceName();
        }

        public String toString() {
            return this.referenceSequence.getSequenceName() + ":" + this.position;
        }

        public int getSequenceLength() {
            return this.referenceSequence.getSequenceLength();
        }
    }

    public static class RecordAndOffset {
        private final SAMRecord record;
        private final int offset;

        public RecordAndOffset(SAMRecord sAMRecord, int n) {
            this.offset = n;
            this.record = sAMRecord;
        }

        public int getOffset() {
            return this.offset;
        }

        public SAMRecord getRecord() {
            return this.record;
        }

        public byte getReadBase() {
            return this.record.getReadBases()[this.offset];
        }

        public byte getBaseQuality() {
            return this.record.getBaseQualities()[this.offset];
        }
    }
}

