/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SeekableBufferedStream
extends SeekableStream {
    public static final int DEFAULT_BUFFER_SIZE = 512000;
    private final int bufferSize;
    final SeekableStream wrappedStream;
    ExtBufferedInputStream bufferedStream;
    long position;

    public SeekableBufferedStream(SeekableStream seekableStream, int n) {
        this.bufferSize = n;
        this.wrappedStream = seekableStream;
        this.position = 0L;
        this.bufferedStream = new ExtBufferedInputStream(this.wrappedStream, n);
    }

    public SeekableBufferedStream(SeekableStream seekableStream) {
        this(seekableStream, 512000);
    }

    @Override
    public long length() {
        return this.wrappedStream.length();
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < (long)this.bufferedStream.getBytesInBufferAvailable()) {
            long l2 = this.bufferedStream.skip(l);
            this.position += l2;
            return l2;
        }
        long l3 = this.position + l;
        this.seek(l3);
        return l;
    }

    @Override
    public void seek(long l) throws IOException {
        this.position = l;
        this.wrappedStream.seek(l);
        this.bufferedStream = new ExtBufferedInputStream(this.wrappedStream, this.bufferSize);
    }

    @Override
    public int read() throws IOException {
        int n = this.bufferedStream.read();
        ++this.position;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.bufferedStream.read(byArray, n, n2);
        if (n3 > 0) {
            int n4;
            if (n3 < n2 && (n4 = this.bufferedStream.read(byArray, n3 + n, n2 - n3)) > 0) {
                n3 += n4;
            }
            this.position += (long)n3;
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.wrappedStream.length();
    }

    @Override
    public String getSource() {
        return this.wrappedStream.getSource();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    private class ExtBufferedInputStream
    extends BufferedInputStream {
        private ExtBufferedInputStream(InputStream inputStream, int n) {
            super(inputStream, n);
        }

        int getBytesInBufferAvailable() {
            if (this.count == this.pos) {
                return 0;
            }
            return this.buf.length - this.pos;
        }
    }
}

