/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman;

import htsjdk.samtools.cram.encoding.huffman.HuffmanLeaf;
import htsjdk.samtools.cram.encoding.huffman.HuffmanNode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HuffmanCode {
    public static <T> HuffmanTree<T> buildTree(int[] nArray, T[] TArray) {
        LinkedList<HuffmanTree> linkedList = new LinkedList<HuffmanTree>();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            linkedList.add(new HuffmanLeaf<T>(nArray[i], TArray[i]));
        }
        Comparator comparator = new Comparator<HuffmanTree<T>>(){

            @Override
            public int compare(HuffmanTree<T> huffmanTree, HuffmanTree<T> huffmanTree2) {
                return huffmanTree.frequency - huffmanTree2.frequency;
            }
        };
        while (linkedList.size() > 1) {
            Collections.sort(linkedList, comparator);
            HuffmanTree huffmanTree = (HuffmanTree)linkedList.remove();
            HuffmanTree huffmanTree2 = (HuffmanTree)linkedList.remove();
            linkedList.add(new HuffmanNode(huffmanTree, huffmanTree2));
        }
        return linkedList.isEmpty() ? null : (HuffmanTree)linkedList.remove();
    }

    public static <T> void getValuesAndBitLengths(List<T> list, List<Integer> list2, HuffmanTree<T> huffmanTree) {
        TreeMap treeMap = new TreeMap();
        HuffmanCode.getBitCode(huffmanTree, new HuffmanBitCode(), treeMap);
        for (Object k : treeMap.keySet()) {
            HuffmanBitCode huffmanBitCode = (HuffmanBitCode)treeMap.get(k);
            list.add(k);
            list2.add(huffmanBitCode.bitLength);
        }
    }

    private static <T> void getBitCode(HuffmanTree<T> huffmanTree, HuffmanBitCode<T> huffmanBitCode, Map<T, HuffmanBitCode<T>> map) {
        if (huffmanTree instanceof HuffmanLeaf) {
            HuffmanLeaf huffmanLeaf = (HuffmanLeaf)huffmanTree;
            HuffmanBitCode huffmanBitCode2 = new HuffmanBitCode();
            huffmanBitCode2.bitCode = huffmanBitCode.bitCode;
            huffmanBitCode2.bitLength = huffmanBitCode.bitLength;
            map.put(huffmanLeaf.value, huffmanBitCode2);
        } else if (huffmanTree instanceof HuffmanNode) {
            HuffmanNode huffmanNode = (HuffmanNode)huffmanTree;
            huffmanBitCode.bitCode <<= 1;
            ++huffmanBitCode.bitLength;
            HuffmanCode.getBitCode(huffmanNode.left, huffmanBitCode, map);
            huffmanBitCode.bitCode >>>= 1;
            --huffmanBitCode.bitLength;
            huffmanBitCode.bitCode = huffmanBitCode.bitCode << 1 | 1L;
            ++huffmanBitCode.bitLength;
            HuffmanCode.getBitCode(huffmanNode.right, huffmanBitCode, map);
            huffmanBitCode.bitCode >>>= 1;
            --huffmanBitCode.bitLength;
        }
    }

    private static class HuffmanBitCode<T> {
        long bitCode;
        int bitLength;

        private HuffmanBitCode() {
        }
    }
}

