/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;

public class SAMTestUtil {
    public void assertPairValid(SAMRecord sAMRecord, SAMRecord sAMRecord2) throws SanityCheckFailedException {
        SAMTestUtil.assertEquals(sAMRecord.getReadName(), sAMRecord2.getReadName());
        SAMTestUtil.assertTrue(sAMRecord.getFirstOfPairFlag());
        SAMTestUtil.assertTrue(sAMRecord2.getSecondOfPairFlag());
        SAMTestUtil.assertFalse(sAMRecord2.getFirstOfPairFlag());
        SAMTestUtil.assertFalse(sAMRecord.getSecondOfPairFlag());
        if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag()) {
            SAMTestUtil.assertNotSame(sAMRecord.getReadNegativeStrandFlag(), sAMRecord2.getReadNegativeStrandFlag());
        }
    }

    public void assertReadValid(SAMRecord sAMRecord) throws SanityCheckFailedException {
        SAMTestUtil.assertEquals(sAMRecord.getReadBases().length, sAMRecord.getBaseQualities().length);
        if (sAMRecord.getReferenceName().equals("*")) {
            SAMTestUtil.assertEquals(sAMRecord.getAlignmentStart(), 0);
            SAMTestUtil.assertTrue(sAMRecord.getReadUnmappedFlag());
        } else {
            SAMTestUtil.assertNotSame(sAMRecord.getAlignmentStart(), 0);
        }
        if (sAMRecord.getReadUnmappedFlag()) {
            SAMTestUtil.assertEquals(sAMRecord.getMappingQuality(), 0);
            SAMTestUtil.assertEquals(sAMRecord.getCigar().getCigarElements().size(), 0);
        } else {
            SAMTestUtil.assertNotSame(sAMRecord.getCigar().getCigarElements(), 0);
        }
        if (sAMRecord.getReadPairedFlag()) {
            if (sAMRecord.getMateReferenceName().equals("*")) {
                SAMTestUtil.assertEquals(sAMRecord.getMateAlignmentStart(), 0);
                SAMTestUtil.assertTrue(sAMRecord.getMateUnmappedFlag());
            } else {
                SAMTestUtil.assertNotSame(sAMRecord.getMateAlignmentStart(), 0);
            }
            if (sAMRecord.getReadUnmappedFlag() || sAMRecord.getMateUnmappedFlag() || !sAMRecord.getReferenceName().equals(sAMRecord.getMateReferenceName())) {
                SAMTestUtil.assertEquals(sAMRecord.getInferredInsertSize(), 0);
            } else {
                SAMTestUtil.assertNotSame(sAMRecord.getInferredInsertSize(), 0);
            }
            if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag()) {
                SAMTestUtil.assertNotSame(sAMRecord.getReadNegativeStrandFlag(), sAMRecord.getMateNegativeStrandFlag());
                SAMTestUtil.assertNotSame(sAMRecord.getMateNegativeStrandFlag(), sAMRecord.getReadName());
            }
        } else {
            SAMTestUtil.assertEquals(sAMRecord.getInferredInsertSize(), 0);
        }
    }

    private static <T> void assertEquals(T t, T t2) {
        if (t == null ? t2 != null : !t.equals(t2)) {
            throw new SanityCheckFailedException("\"" + t + "\" does not equal \"" + t2 + "\"");
        }
    }

    private static <T> void assertNotSame(T t, T t2) {
        if (t != t2) {
            throw new SanityCheckFailedException("\"" + t + "\" and \"" + t2 + "\" are not the same object");
        }
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new SanityCheckFailedException("The condition is false");
        }
    }

    private static void assertFalse(boolean bl) {
        if (bl) {
            throw new SanityCheckFailedException("The condition is true");
        }
    }

    public static class SanityCheckFailedException
    extends RuntimeException {
        public SanityCheckFailedException(String string) {
            super(string);
        }
    }
}

