/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Comparator;

class ComparableSamRecordIterator
extends PeekableIterator<SAMRecord>
implements Comparable<ComparableSamRecordIterator> {
    private final Comparator<SAMRecord> comparator;
    private final SamReader reader;

    public ComparableSamRecordIterator(SamReader samReader, CloseableIterator<SAMRecord> closeableIterator, Comparator<SAMRecord> comparator) {
        super(closeableIterator);
        this.reader = samReader;
        this.comparator = comparator;
    }

    public SamReader getReader() {
        return this.reader;
    }

    @Override
    public int compareTo(ComparableSamRecordIterator comparableSamRecordIterator) {
        if (this.comparator.getClass() != comparableSamRecordIterator.comparator.getClass()) {
            throw new IllegalStateException("Attempt to compare two ComparableSAMRecordIterators that have different orderings internally");
        }
        SAMRecord sAMRecord = (SAMRecord)this.peek();
        SAMRecord sAMRecord2 = (SAMRecord)comparableSamRecordIterator.peek();
        return this.comparator.compare(sAMRecord, sAMRecord2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((ComparableSamRecordIterator)object) == 0;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ComparableSamRecordIterator should not be hashed because it can change value");
    }
}

