/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.senders;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import edu.mayo.senders.Sender;
import java.io.IOException;

public class RabbitSender
implements Sender {
    private String queue = "hello";
    private ConnectionFactory factory = null;
    private Connection connection = null;
    private Channel channel = null;
    private String host = "localhost";
    private int port = 5673;

    public RabbitSender(String queue) {
        this.queue = queue;
        this.init();
    }

    public RabbitSender(String host, String queue) {
        this.host = host;
        this.queue = queue;
        this.init();
    }

    public RabbitSender(String host, int port, String queue) {
        this.host = host;
        this.port = port;
        this.queue = queue;
        this.init();
    }

    private void init() {
        this.factory = new ConnectionFactory();
        this.factory.setHost(this.host);
        this.factory.setPort(this.port);
        try {
            this.connection = this.factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.queueDeclare(this.queue, false, false, false, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLocation(String location) {
        this.queue = location;
        this.init();
    }

    public void write(String message) {
        try {
            this.channel.basicPublish("", this.queue, null, message.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.channel.close();
            this.connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

