/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FileMemData;

class FileMem
extends FileBase {
    private final FileMemData data;
    private final boolean readOnly;
    private long pos;

    FileMem(FileMemData fileMemData, boolean bl) {
        this.data = fileMemData;
        this.readOnly = bl;
    }

    public long size() {
        return this.data.length();
    }

    public FileChannel truncate(long l) throws IOException {
        if (l < this.size()) {
            this.data.touch(this.readOnly);
            this.pos = Math.min(this.pos, l);
            this.data.truncate(l);
        }
        return this;
    }

    public FileChannel position(long l) {
        this.pos = (int)l;
        return this;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        this.data.touch(this.readOnly);
        this.pos = this.data.readWrite(this.pos, byteBuffer.array(), byteBuffer.position(), n, true);
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        long l = this.data.readWrite(this.pos, byteBuffer.array(), byteBuffer.position(), n, false);
        n = (int)(l - this.pos);
        if (n <= 0) {
            return -1;
        }
        byteBuffer.position(byteBuffer.position() + n);
        this.pos = l;
        return n;
    }

    public long position() {
        return this.pos;
    }

    public void implCloseChannel() throws IOException {
        this.pos = 0L;
    }

    public void force(boolean bl) throws IOException {
    }

    public synchronized FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return null;
    }

    public String toString() {
        return this.data.getName();
    }
}

