/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    CommandContainer(Parser parser, String string, Prepared prepared) {
        super(parser, string);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string = this.prepared.getSQL();
            ArrayList<Parameter> arrayList = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(string);
            long l = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> arrayList2 = this.prepared.getParameters();
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = arrayList.get(i);
                if (!parameter.isValueSet()) continue;
                Value value = parameter.getValue(this.session);
                Parameter parameter2 = arrayList2.get(i);
                parameter2.setValue(value);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l);
        }
    }

    @Override
    public int update() {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.session.setLastIdentity(ValueNull.INSTANCE);
        this.prepared.checkParameters();
        int n = this.prepared.update();
        this.prepared.trace(this.startTime, n);
        this.setProgress(6);
        return n;
    }

    @Override
    public ResultInterface query(int n) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface resultInterface = this.prepared.query(n);
        this.prepared.trace(this.startTime, resultInterface.getRowCount());
        this.setProgress(6);
        return resultInterface;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }
}

