/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createcatalog;

import com.tinkerpop.pipes.AbstractPipe;
import java.io.IOException;
import java.util.NoSuchElementException;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class BgzipWriterString
extends AbstractPipe<String, String> {
    private String mBgzipOutFilePath;
    private BlockCompressedOutputStream mBgzipOutStream;

    public BgzipWriterString(String bgzipOutFilePath) {
        this.mBgzipOutFilePath = bgzipOutFilePath;
    }

    protected String processNextStart() throws NoSuchElementException {
        try {
            String nextLine = (String)this.starts.next();
            if (this.mBgzipOutStream == null) {
                this.mBgzipOutStream = new BlockCompressedOutputStream(this.mBgzipOutFilePath, 9);
            }
            this.mBgzipOutStream.write((nextLine + "\n").getBytes());
            return nextLine;
        }
        catch (NoSuchElementException noSuchExc) {
            try {
                this.mBgzipOutStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchElementException("Error closing the bgzip stream: " + e.getMessage());
            }
            throw new NoSuchElementException("No more data");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error writing to bgzip file");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error creating tabix file");
        }
    }
}

