/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createCatalogProps;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import edu.mayo.pipes.history.ColumnMetaData;
import java.util.ArrayList;

public class ColumnTypeCounter {
    public static final String[] DELIMITERS = new String[]{",", ";"};
    private ColumnMetaData mColMeta = new ColumnMetaData();
    private int mCountJsonArray = 0;
    private ArrayList<String> mExamples = new ArrayList();
    private JsonParser jsonParser = new JsonParser();

    public ColumnTypeCounter(String colName, String description) {
        this.mColMeta.setColumnName(colName);
        this.mColMeta.setDescription(description);
    }

    public ColumnMetaData getColumnMetaData() {
        return this.mColMeta;
    }

    public void setTypeAndCountForColumnMetaData() {
        if (this.mColMeta.getType() == null) {
            this.mColMeta.setType(ColumnMetaData.Type.String);
        }
        if (this.mColMeta.getType().equals((Object)ColumnMetaData.Type.Boolean)) {
            this.mColMeta.setCount("0");
        } else if (this.mCountJsonArray > 0) {
            this.mColMeta.setCount(".");
        } else {
            this.mColMeta.setCount("1");
        }
    }

    protected String determineCount(JsonElement jsonElem) {
        String count = "1";
        if (jsonElem.isJsonObject()) {
            count = "1";
        } else if (jsonElem.isJsonArray()) {
            count = ".";
        } else if (jsonElem.isJsonPrimitive()) {
            JsonPrimitive prim = (JsonPrimitive)jsonElem;
            count = prim.isJsonArray() ? "." : (prim.isBoolean() ? "0" : "1");
        }
        return count;
    }

    protected String determineCount(String value) {
        return this.determineCount(this.jsonParser.parse(value));
    }

    protected ColumnMetaData.Type determineType(JsonElement jsonElem) {
        ColumnMetaData.Type type = null;
        if (jsonElem.isJsonNull()) {
            type = null;
        } else if (jsonElem.isJsonObject()) {
            type = ColumnMetaData.Type.JSON;
        } else if (jsonElem.isJsonArray()) {
            type = this.getTypeFromJsonArray((JsonArray)jsonElem);
            ++this.mCountJsonArray;
        } else {
            type = jsonElem.isJsonPrimitive() ? this.getTypeFromJsonPrimitive((JsonPrimitive)jsonElem) : ColumnMetaData.Type.String;
        }
        return type;
    }

    protected ColumnMetaData.Type determineType(String value) {
        return this.determineType(this.jsonParser.parse(value));
    }

    private ColumnMetaData.Type getTypeFromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        ColumnMetaData.Type type = null;
        int i = 0;
        while (type == null && i < jsonArray.size()) {
            JsonElement elem;
            if ((elem = jsonArray.get(i++)).isJsonNull()) {
                type = null;
                continue;
            }
            if (elem.isJsonObject()) {
                type = ColumnMetaData.Type.JSON;
                continue;
            }
            if (elem.isJsonPrimitive()) {
                type = this.getTypeFromJsonPrimitive((JsonPrimitive)elem);
                continue;
            }
            type = ColumnMetaData.Type.String;
        }
        return type;
    }

    private ColumnMetaData.Type getTypeFromJsonPrimitive(JsonPrimitive prim) {
        ColumnMetaData.Type type = null;
        if (prim.isBoolean()) {
            type = ColumnMetaData.Type.Boolean;
        } else if (prim.isNumber()) {
            if (this.isInt(prim.toString())) {
                type = ColumnMetaData.Type.Integer;
            } else if (this.isFloat(prim.toString())) {
                type = ColumnMetaData.Type.Float;
            }
        } else {
            type = ColumnMetaData.Type.String;
        }
        return type;
    }

    private boolean isFloat(String val) {
        try {
            Float.parseFloat(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isInt(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

