/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class VepCsqSeqOntComparator
implements Comparator<String> {
    private static final Map<String, Integer> sSeqMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
    private static final Logger sLogger = Logger.getLogger(VepCsqSeqOntComparator.class);

    @Override
    public int compare(String seqOnt1, String seqOnt2) {
        String mostSevere1 = this.getMostSevere(seqOnt1);
        String mostSevere2 = this.getMostSevere(seqOnt2);
        int sevScore1 = this.getScore(mostSevere1);
        int sevScore2 = this.getScore(mostSevere2);
        return sevScore2 - sevScore1;
    }

    protected int getScore(String mostSevere1) {
        Integer score = sSeqMap.get(mostSevere1);
        if (score == null) {
            score = 0;
            String MSG = "Warning: VEP CSQ SequenceOntology not recognized: " + mostSevere1;
            System.err.println(MSG);
            sLogger.warn((Object)MSG);
        }
        return score;
    }

    protected String getMostSevere(String seqOnt) {
        if (seqOnt == null) {
            seqOnt = "";
        }
        String mostSev = seqOnt;
        if (seqOnt.contains("&")) {
            String[] seqs = seqOnt.split("&");
            Arrays.sort(seqs, this);
            mostSev = seqs[0];
        }
        return mostSev;
    }

    static {
        int val = 100;
        sSeqMap.put("transcript_ablation", val--);
        sSeqMap.put("splice_acceptor_variant", val--);
        sSeqMap.put("splice_donor_variant", val--);
        sSeqMap.put("stop_gained", val--);
        sSeqMap.put("frameshift_variant", val--);
        sSeqMap.put("stop_lost", val--);
        sSeqMap.put("initiator_codon_variant", val--);
        sSeqMap.put("transcript_amplification", val--);
        sSeqMap.put("inframe_insertion", val--);
        sSeqMap.put("inframe_deletion", val--);
        sSeqMap.put("missense_variant", val--);
        sSeqMap.put("splice_region_variant", val--);
        sSeqMap.put("incomplete_terminal_codon_variant", val--);
        sSeqMap.put("stop_retained_variant", val--);
        sSeqMap.put("synonymous_variant", val--);
        sSeqMap.put("coding_sequence_variant", val--);
        sSeqMap.put("mature_miRNA_variant", val--);
        sSeqMap.put("5_prime_UTR_variant", val--);
        sSeqMap.put("3_prime_UTR_variant", val--);
        sSeqMap.put("non_coding_transcript_exon_variant", val--);
        sSeqMap.put("non_coding_exon_variant", val--);
        sSeqMap.put("nc_transcript_exon_variant", val--);
        sSeqMap.put("nc_exon_variant", val--);
        sSeqMap.put("intron_variant", val--);
        sSeqMap.put("NMD_transcript_variant", val--);
        sSeqMap.put("non_coding_transcript_variant", val--);
        sSeqMap.put("nc_transcript_variant", val--);
        sSeqMap.put("upstream_gene_variant", val--);
        sSeqMap.put("downstream_gene_variant", val--);
        sSeqMap.put("TFBS_ablation", val--);
        sSeqMap.put("TFBS_amplification", val--);
        sSeqMap.put("TF_binding_site_variant", val--);
        sSeqMap.put("regulatory_region_ablation", val--);
        sSeqMap.put("regulatory_region_amplification", val--);
        sSeqMap.put("regulatory_region_variant", val--);
        sSeqMap.put("feature_elongation", val--);
        sSeqMap.put("feature_truncation", val--);
        sSeqMap.put("intergenic_variant", val--);
    }
}

