/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class CosmicFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"Mutation_ID", "Mutation_CDS", "Mutation_AA", "Mutation_GRCh37_strand"};
    private static final JsonPath PATH_MUTATIONID = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_MUTATIONCDS = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_MUTATIONAA = JsonPath.compile((String)JSON_DRILL_PATHS[2], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_GRCH37STRAND = JsonPath.compile((String)JSON_DRILL_PATHS[3], (Predicate[])new Predicate[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.COSMIC;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("COSMIC.Mutation_ID", "COSMIC.Mutation_CDS", "COSMIC.Mutation_AA", "COSMIC.strand");
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_MUTATIONID, json), FormatUtils.drill(PATH_MUTATIONCDS, json), FormatUtils.drill(PATH_MUTATIONAA, json), FormatUtils.drill(PATH_GRCH37STRAND, json));
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }
}

