/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.SNPEff;

import edu.mayo.bior.pipeline.SNPEff.SNPEffHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SNPEffectHolder {
    private String Effect;
    private String Codon_change;
    private String Amino_acid_change;
    private String Gene_name;
    private String Gene_bioType;
    private String Coding;
    private String Transcript;
    private String Exon;
    private SNPEffHelper.EffectImpact impact;
    private SNPEffHelper.EffectFunctionalClass effectFunctionalClass;

    public SNPEffectHolder(Map<String, String> splitEffectCoreValues) {
        this.Effect = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.EFFECT_KEY.getKeyName());
        this.impact = SNPEffHelper.EffectImpact.valueOf(splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.IMPACT_KEY.getKeyName()));
        this.effectFunctionalClass = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName()).trim().length() > 0 ? SNPEffHelper.EffectFunctionalClass.valueOf(splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName())) : SNPEffHelper.EffectFunctionalClass.NONE;
        this.Codon_change = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.CODON_CHANGE_KEY.getKeyName());
        this.Amino_acid_change = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.AMINO_ACID_CHANGE_KEY.getKeyName());
        this.Gene_name = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.GENE_NAME_KEY.getKeyName());
        this.Gene_bioType = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.GENE_BIOTYPE_KEY.getKeyName());
        this.Coding = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.CODING.getKeyName());
        this.Transcript = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.TRANSCRIPT_ID_KEY.getKeyName());
        this.Exon = splitEffectCoreValues.get(SNPEffHelper.InfoFieldKey.EXON_ID_KEY.getKeyName());
    }

    public boolean isHigherImpactThan(SNPEffectHolder other) {
        if (this.isCoding() && !other.isCoding()) {
            return true;
        }
        if (!this.isCoding() && other.isCoding()) {
            return false;
        }
        if (this.impact.isHigherImpactThan(other.impact)) {
            return true;
        }
        if (this.impact.isSameImpactAs(other.impact)) {
            return this.effectFunctionalClass.isHigherPriorityThan(other.effectFunctionalClass);
        }
        return false;
    }

    public boolean isCoding() {
        return this.Coding == "CODING";
    }

    public List<String> getAnnotationAsList() {
        ArrayList<String> mse = new ArrayList<String>();
        mse.add(this.getEffect());
        mse.add(this.getEffect_impact());
        mse.add(this.getFunctional_class());
        mse.add(this.getCodon_change());
        mse.add(this.getAmino_acid_change());
        mse.add(this.getGene_name());
        mse.add(this.getGene_bioType());
        mse.add(this.getCoding());
        mse.add(this.getTranscript());
        mse.add(this.getExon());
        return mse;
    }

    public String getEffect() {
        return this.Effect;
    }

    public String getEffect_impact() {
        return this.impact.name();
    }

    public String getFunctional_class() {
        return this.effectFunctionalClass.name();
    }

    public String getCodon_change() {
        return this.Codon_change;
    }

    public String getAmino_acid_change() {
        return this.Amino_acid_change;
    }

    public String getGene_name() {
        return this.Gene_name;
    }

    public String getGene_bioType() {
        return this.Gene_bioType;
    }

    public String getCoding() {
        return this.Coding;
    }

    public String getTranscript() {
        return this.Transcript;
    }

    public String getExon() {
        return this.Exon;
    }
}

