/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.bioinformatics.VCF2VariantPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class VCF2VariantCommand
implements CommandPlugin {
    private static final char OPTION_ADD_FLAG_FALSES = 'f';
    private UnixStreamPipeline pipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        try {
            Metadata metadata = new Metadata(this.operation);
            HistoryInPipe preLogic = new HistoryInPipe(metadata);
            VCF2VariantPipe logic = new VCF2VariantPipe();
            logic.setAddFlagFalseValuesToJson(this.isAddFlagFalseValues(line));
            HistoryOutPipe postLogic = new HistoryOutPipe();
            this.pipeline.execute(preLogic, logic, postLogic);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            throw e;
        }
    }

    private boolean isAddFlagFalseValues(CommandLine line) {
        return line.hasOption('f');
    }
}

