/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.catalog.CatalogDataSource;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.markdown.MarkdownInfo;
import edu.mayo.bior.catalog.markdown.MarkdownUtils;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.ComparisonStatsImpl;
import edu.mayo.bior.cli.cmd.CommandUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;

public class CatalogMarkdownCommand
implements CommandPlugin {
    private static final String OPTION_CATALOG_BGZ_FILE = "d";
    private static final String OPTION_PREVIOUS_MARKDOWN_FILE = "p";
    private static final String OPTION_OUTPUT_DIR = "o";
    private static final String OPTION_COMPARISON_JSON_FILE = "c";
    private File defaultOutputDir = new File(".");

    public void init(Properties properties) throws Exception {
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        File catalogFile = this.getCatalogFile(cl);
        File outputDir = this.getOutputDir(cl);
        File previousMarkdown = this.getPreviousMarkdown(cl);
        File comparisonJsonFile = this.getComparisonJsonFile(cl);
        MarkdownInfo markdownStr = this.createMarkdown(catalogFile, outputDir, previousMarkdown, comparisonJsonFile);
    }

    private File getCatalogFile(CommandLine cl) throws Exception {
        List<CommandUtil.FileAttributes> catalogFileAttrs = Arrays.asList(CommandUtil.FileAttributes.EXISTS, CommandUtil.FileAttributes.READABLE);
        File catalogFile = CommandUtil.handleFile(cl, OPTION_CATALOG_BGZ_FILE, catalogFileAttrs);
        return catalogFile;
    }

    private File getPreviousMarkdown(CommandLine cl) {
        File outputDir;
        File file = outputDir = cl.hasOption(OPTION_PREVIOUS_MARKDOWN_FILE) ? new File(cl.getOptionValue(OPTION_PREVIOUS_MARKDOWN_FILE)) : this.defaultOutputDir;
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    private File getOutputDir(CommandLine cl) throws Exception {
        File outputDir;
        File file = outputDir = cl.hasOption(OPTION_OUTPUT_DIR) ? new File(cl.getOptionValue(OPTION_OUTPUT_DIR)) : this.defaultOutputDir;
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (!(outputDir.canRead() && outputDir.canExecute() && outputDir.canWrite())) {
            throw new RuntimeException("Markdown output directory must be readable, writeable, and executable");
        }
        return outputDir;
    }

    private File getComparisonJsonFile(CommandLine cl) throws Exception {
        if (cl.hasOption(OPTION_COMPARISON_JSON_FILE)) {
            return CommandUtil.handleFile(cl, OPTION_COMPARISON_JSON_FILE, Arrays.asList(CommandUtil.FileAttributes.EXISTS, CommandUtil.FileAttributes.READABLE));
        }
        return null;
    }

    public MarkdownInfo createMarkdown(File catalogFile, File outputDir, File previousMarkdownFile, File comparisonJsonFile) throws IOException, CatalogFormatException, TransformException {
        String catalogMarkdownTemplate = this.loadCatalogMarkdownTemplate();
        MarkdownInfo markdownInfo = this.loadMarkdownInfo(catalogFile);
        markdownInfo.markdownOutputStr = catalogMarkdownTemplate.replace(MarkdownTemplateKeys.CATALOG_NAME.toString(), MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getShortUniqueName())).replace(MarkdownTemplateKeys.DEPRECATION_NOTICE.toString(), markdownInfo.deprecationNotes).replace(MarkdownTemplateKeys.DATASOURCE_PROPERTIES.toString(), this.getDatasourcePropertiesMarkdown(markdownInfo)).replace(MarkdownTemplateKeys.COLUMNSTSV_PROPERTIES.toString(), this.getColumnsTsvMarkdown(markdownInfo)).replace(MarkdownTemplateKeys.CATALOG_PATH.toString(), MarkdownUtils.escapeChrs(catalogFile.getCanonicalPath())).replace(MarkdownTemplateKeys.REFDATA_PATH.toString(), this.isExistsAndReadable(markdownInfo.refdataSourceDir) ? MarkdownUtils.escapeChrs(markdownInfo.refdataSourceDir.getCanonicalPath()) : "");
        ArrayList<ComparisonStatsImpl> transformers = new ArrayList<ComparisonStatsImpl>();
        transformers.add(new ComparisonStatsImpl(comparisonJsonFile));
        for (MarkdownTransformer markdownTransformer : transformers) {
            markdownInfo.markdownOutputStr = markdownTransformer.transform(markdownInfo.markdownOutputStr);
        }
        outputDir.mkdirs();
        markdownInfo.markdownOutputFile = new File(outputDir, catalogFile.getName().replace(".tsv.bgz", ".md"));
        FileUtils.write((File)markdownInfo.markdownOutputFile, (CharSequence)markdownInfo.markdownOutputStr);
        return markdownInfo;
    }

    private String loadCatalogMarkdownTemplate() throws IOException {
        String path = this.getClass().getResource("/catalogMarkdownTemplate.md").getPath();
        return FileUtils.readFileToString((File)new File(path));
    }

    private MarkdownInfo loadMarkdownInfo(File catalogFile) throws CatalogFormatException, IOException {
        MarkdownInfo markdownInfo = new MarkdownInfo();
        markdownInfo.catalogTsvBgzFile = catalogFile;
        markdownInfo.refdataSourceDir = this.getRefDataSourceFromBuildInfoTxt(catalogFile);
        File datasourcePropsPath = new File(catalogFile.getParentFile(), catalogFile.getName().replace(".tsv.bgz", ".datasource.properties"));
        markdownInfo.datasourceProperties = new CatalogDataSource(datasourcePropsPath);
        File columnsTsv = new File(catalogFile.getParentFile(), catalogFile.getName().replace(".tsv.bgz", ".columns.tsv"));
        markdownInfo.columns = new ColumnMetaDataOperations(columnsTsv).loadAsList();
        markdownInfo.deprecationNotes = this.loadDeprecationNotes(catalogFile);
        return markdownInfo;
    }

    private File getRefDataSourceFromBuildInfoTxt(File catalogFile) throws IOException {
        String makeJsonArgs;
        String[] args;
        File buildInfoTxtFile = new File(catalogFile.getParentFile().getCanonicalPath() + "/build", "build_info.txt");
        if (!this.isExistsAndReadable(buildInfoTxtFile)) {
            return null;
        }
        Properties datasrcProps = new Properties();
        FileInputStream fin = new FileInputStream(buildInfoTxtFile);
        datasrcProps.load(fin);
        if (fin != null) {
            fin.close();
        }
        if ((args = (makeJsonArgs = datasrcProps.getProperty(BuildInfoKey.MAKE_JSON_ARGS.toString()).trim()).split(" ")).length == 0 || args[0].trim().length() == 0) {
            return null;
        }
        File refDataDir = new File(args[0].trim());
        if (!this.isExistsAndReadable(refDataDir)) {
            return null;
        }
        return refDataDir;
    }

    protected String getDatasourcePropertiesMarkdown(MarkdownInfo markdownInfo) {
        StringBuilder str = new StringBuilder("Property | Values\n");
        str.append("------------ | ------------\n");
        str.append("ShortUniqueName | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getShortUniqueName()) + "\n");
        str.append("Description | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getDescription()) + "\n");
        str.append("Source | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getSource()) + "\n");
        str.append("Dataset | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getDataset()) + "\n");
        str.append("Version | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getVersion()) + "\n");
        str.append("Build | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getBuild()) + "\n");
        str.append("Format | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getFormat()) + "\n");
        str.append("Human Build/Assembly | " + MarkdownUtils.escapeChrs(markdownInfo.datasourceProperties.getHumanBuildAssembly().toString()) + "\n");
        return str.toString();
    }

    protected String getColumnsTsvMarkdown(MarkdownInfo markdownInfo) {
        StringBuilder str = new StringBuilder("ColumnName | Type | Count | Description | HumanReadableName\n");
        str.append("------------ | ------------ | ------------ | ------------ | ------------\n");
        for (ColumnMetaData colMeta : markdownInfo.columns) {
            str.append(MarkdownUtils.escapeChrs(colMeta.getColumnName()) + " | " + MarkdownUtils.escapeChrs(colMeta.getType().toString()) + " | " + MarkdownUtils.escapeChrs(colMeta.getCount()) + " | " + MarkdownUtils.escapeChrs(colMeta.getDescription()) + " | " + MarkdownUtils.escapeChrs(colMeta.getHumanReadableName()) + "\n");
        }
        return str.toString();
    }

    private String loadDeprecationNotes(File catalogFile) throws IOException {
        File deprecationFile = new File(catalogFile.getParentFile(), catalogFile.getName().replace(".tsv.bgz", ".DEPRECATED.txt"));
        if (!this.isExistsAndReadable(deprecationFile)) {
            return "";
        }
        String notes = "> " + MarkdownUtils.escapeChrs(FileUtils.readFileToString((File)deprecationFile)).replaceAll("\n", "\n\n> ");
        String warningMsg = "**[DEPRECATED](link \"A catalog may be deprecated if it contains errors, inconsistencies, or ambiguous fields that are fixed in a subsequent catalog\")\nThis catalog is deprecated, and should no longer be used. Please see the latest version of this catalog.**\n\n";
        return warningMsg + notes;
    }

    private boolean isExistsAndReadable(File f) {
        return f != null && f.exists() && f.canRead();
    }

    static enum MarkdownTemplateKeys {
        CATALOG_NAME,
        DEPRECATION_NOTICE,
        DATASOURCE_PROPERTIES,
        COLUMNSTSV_PROPERTIES,
        FAQ_PROPERTIES,
        CATALOG_PATH,
        REFDATA_PATH;

    }
}

