/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.MarkdownUtils;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogDiffStatistics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class CatalogRowUpdateImpl
implements MarkdownTransformer {
    static final String TEMPLATE_KEYWORD = "COMPARISON_STATISTICS_ROW_UPDATE_TABLE";
    private CatalogDiffStatistics stats;

    CatalogRowUpdateImpl(CatalogDiffStatistics stats) {
        this.stats = stats;
    }

    @Override
    public String transform(String markdown) throws TransformException {
        if (this.stats == null) {
            return markdown.replace(TEMPLATE_KEYWORD, "Information is not available");
        }
        return markdown.replace(TEMPLATE_KEYWORD, MarkdownUtils.chompTrailingNewlines(this.buildTable()));
    }

    private String buildTable() {
        long intersectionRows = this.stats.getSummaryStats().getCatalogOldEntries() - this.stats.getSummaryStats().getCatalogEntriesRemoved();
        long changedRows = this.stats.getSummaryStats().getCatalogEntriesChanged() - this.stats.getSummaryStats().getCatalogEntriesRemoved() - this.stats.getSummaryStats().getCatalogEntriesAdded();
        long unchangedRows = intersectionRows - changedRows;
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        pWtr.println("Metric | Description | Count | % of Intersection");
        pWtr.println("--- | --- | --- | ---");
        pWtr.println(String.format("%s | %s | %d | %.1f%%", "Intersection Rows", "# of rows present in both previous and current catalogs", intersectionRows, Float.valueOf((float)intersectionRows / (float)intersectionRows * 100.0f)));
        pWtr.println(String.format("%s | %s | %d | %.1f%%", "Unchanged Rows", "intersection rows with no column changes", unchangedRows, Float.valueOf((float)unchangedRows / (float)intersectionRows * 100.0f)));
        pWtr.println(String.format("%s | %s | %d | %.1f%%", "Updated Rows", "intersection rows that had at least 1 column change", changedRows, Float.valueOf((float)changedRows / (float)intersectionRows * 100.0f)));
        IOUtils.closeQuietly((Writer)pWtr);
        IOUtils.closeQuietly((Writer)sWtr);
        return sWtr.toString();
    }
}

