/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.MarkdownUtils;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogDiffStatistics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class CatalogColumnChangesImpl
implements MarkdownTransformer {
    static final String TEMPLATE_KEYWORD = "COMPARISON_STATISTICS_COL_CHANGES_TABLE";
    private CatalogDiffStatistics stats;

    CatalogColumnChangesImpl(CatalogDiffStatistics stats) {
        this.stats = stats;
    }

    @Override
    public String transform(String markdown) throws TransformException {
        if (this.stats == null) {
            return markdown.replace(TEMPLATE_KEYWORD, "Information is not available");
        }
        return markdown.replace(TEMPLATE_KEYWORD, MarkdownUtils.chompTrailingNewlines(this.buildTable()));
    }

    private List<CatalogDiffStatistics.ColumnStats> getRemovedColumns() {
        ArrayList<CatalogDiffStatistics.ColumnStats> list = new ArrayList<CatalogDiffStatistics.ColumnStats>();
        for (CatalogDiffStatistics.ColumnStats columnStats : this.stats.getColumnStats()) {
            if (columnStats.getRemoved() != this.stats.getSummaryStats().getCatalogOldEntries()) continue;
            list.add(columnStats);
        }
        return list;
    }

    private List<CatalogDiffStatistics.ColumnStats> getAddedColumns() {
        ArrayList<CatalogDiffStatistics.ColumnStats> list = new ArrayList<CatalogDiffStatistics.ColumnStats>();
        for (CatalogDiffStatistics.ColumnStats columnStats : this.stats.getColumnStats()) {
            if (columnStats.getAdded() < this.stats.getSummaryStats().getCatalogOldEntries()) continue;
            list.add(columnStats);
        }
        return list;
    }

    private String buildTable() {
        List<CatalogDiffStatistics.ColumnStats> addedColumnList = this.getAddedColumns();
        List<CatalogDiffStatistics.ColumnStats> removedColumnList = this.getRemovedColumns();
        int supersetAllCols = this.stats.getColumnStats().length;
        int removedCols = removedColumnList.size();
        int addedCols = addedColumnList.size();
        int previousCols = supersetAllCols - addedCols;
        int currentCols = supersetAllCols - removedCols;
        int netDifference = currentCols - previousCols;
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        pWtr.println("Metric | Description | Count");
        pWtr.println("--- | --- | ---");
        pWtr.println(String.format("%s | %s | %d", "Previous Columns", "# of columns in the previous catalog", previousCols));
        pWtr.println(String.format("%s | %s | %s", "Removed Columns", "# of columns removed from the previous catalog", MarkdownUtils.positiveNumPrint(-1 * removedCols)));
        pWtr.println(String.format("%s | %s | %s", "Added Columns", "# of columns added to the previous catalog", MarkdownUtils.positiveNumPrint(addedCols)));
        pWtr.println(String.format("%s | %s | %d", "Current Columns", "# of columns in the current catalog", currentCols));
        pWtr.println(String.format("%s | %s | %s", "Net Difference", "Difference between Previous Columns and Current Columns", MarkdownUtils.positiveNumPrint(netDifference)));
        IOUtils.closeQuietly((Writer)pWtr);
        IOUtils.closeQuietly((Writer)sWtr);
        return sWtr.toString();
    }
}

