/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.index;

import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import edu.mayo.pipes.util.index.H2Connection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

public class IndexDatabaseCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndexH2(String bgzipPath, int keyCol, String jsonPath, String outH2DbPath, boolean isVerbose) throws SQLException, IOException, ClassNotFoundException {
        Connection dbConn = null;
        File tempTxtOut = null;
        try {
            IndexDatabaseCreator.println(String.format("Creating index on key '%s', path '%s'", jsonPath, outH2DbPath), true);
            IndexDatabaseCreator.println("-------------- Building Index --------------", isVerbose);
            File h2DbFile = new File(outH2DbPath);
            if (h2DbFile.exists()) {
                IndexDatabaseCreator.println("Deleting file: " + h2DbFile.getCanonicalPath(), isVerbose);
                h2DbFile.delete();
            }
            IndexDatabaseCreator.println("Saving indexes to temp text file...", isVerbose);
            tempTxtOut = new File(h2DbFile.getCanonicalFile().getParentFile(), "/tempIndex_" + jsonPath + ".txt");
            IndexUtils indexUtils = new IndexUtils();
            Properties props = indexUtils.zipIndexesToTextFile(new File(bgzipPath), "\t", keyCol, jsonPath, tempTxtOut, isVerbose);
            int maxKeyLen = (Integer)props.get(IndexUtils.IndexBuilderPropKeys.MaxKeyLen);
            if (0 == maxKeyLen) {
                throw new IllegalArgumentException("There were no keys indexed!  Check your inputs and try again.");
            }
            H2Connection h2Conn = new H2Connection(h2DbFile);
            dbConn = h2Conn.getConn();
            IndexDatabaseCreator.println("Create database table...", isVerbose);
            boolean isKeyAnInteger = (Boolean)props.get(IndexUtils.IndexBuilderPropKeys.IsKeyColAnInt);
            h2Conn.createTable(isKeyAnInteger, maxKeyLen, dbConn);
            IndexDatabaseCreator.println("Add rows from text file to database...", isVerbose);
            this.textIndexesToDb(dbConn, false, tempTxtOut, isVerbose);
            IndexDatabaseCreator.println("Creating index on database...", isVerbose);
            IndexDatabaseCreator.println("  Size of file before H2 index applied: " + h2DbFile.length(), isVerbose);
            h2Conn.createTableIndex(dbConn);
            if (isVerbose) {
                IndexDatabaseCreator.printDatabaseHeader(dbConn);
            }
            IndexDatabaseCreator.println("Num rows in database index: " + IndexDatabaseCreator.countDatabaseRows(h2DbFile), isVerbose);
            IndexDatabaseCreator.println("Size of index file: " + h2DbFile.length(), isVerbose);
            IndexDatabaseCreator.println("Done.", isVerbose);
        }
        finally {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.close();
            }
            if (tempTxtOut != null && tempTxtOut.exists()) {
                tempTxtOut.delete();
            }
        }
    }

    private static void println(String s, boolean isVerbose) {
        if (isVerbose) {
            System.out.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDatabaseHeader(Connection dbConn) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM Indexer");
            int numCols = rs.getMetaData().getColumnCount();
            System.out.println("Column headers:");
            for (int i = 1; i <= numCols; ++i) {
                System.out.println(rs.getMetaData().getColumnName(i) + " (" + rs.getMetaData().getColumnTypeName(i) + ")");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static void printDatabase(File h2DbFile) throws SQLException, ClassNotFoundException, IOException {
        System.out.println("\n\nPrinting table Indexer...");
        System.out.println(IndexDatabaseCreator.getTableAsString(h2DbFile));
    }

    public static String getTableAsString(File h2DbFile) throws SQLException {
        ArrayList<ArrayList<String>> table = IndexDatabaseCreator.getDatabaseTable(h2DbFile);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < table.size(); ++i) {
            str.append(i == 0 ? "" : i + ")");
            for (String col : table.get(i)) {
                str.append("\t" + col);
            }
            str.append("\n");
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ArrayList<String>> getDatabaseTable(File h2DbFile) throws SQLException {
        ArrayList<ArrayList<String>> rows = new ArrayList<ArrayList<String>>();
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = new H2Connection(h2DbFile).getConn();
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM Indexer ORDER BY Key");
            int numCols = rs.getMetaData().getColumnCount();
            ArrayList<String> headerRow = new ArrayList<String>();
            for (int i = 1; i <= numCols; ++i) {
                headerRow.add(rs.getMetaData().getColumnName(i));
            }
            rows.add(headerRow);
            while (rs.next()) {
                ArrayList<String> row = new ArrayList<String>();
                String key = "" + rs.getObject(1);
                Long pos = rs.getLong(2);
                row.add(key);
                row.add("" + pos);
                rows.add(row);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (dbConn != null) {
                dbConn.close();
            }
        }
        return rows;
    }

    public static long countDatabaseRows(File h2DbFile) throws SQLException, ClassNotFoundException, IOException {
        Connection dbConn = new H2Connection(h2DbFile).getConn();
        Statement stmt = dbConn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM Indexer");
        long count = 0L;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        dbConn.close();
        return count;
    }

    private void textIndexesToDb(Connection dbConn, boolean isKeyInteger, File tmpTxt, boolean isVerbose) throws NumberFormatException, SQLException, IOException {
        long numObjects = 0L;
        long numBytesRead = 0L;
        long MB = 0x100000L;
        BufferedReader fin = new BufferedReader(new FileReader(tmpTxt));
        String SQL = "INSERT INTO Indexer (Key, FilePos) VALUES (?, ?)";
        PreparedStatement stmt = dbConn.prepareStatement("INSERT INTO Indexer (Key, FilePos) VALUES (?, ?)");
        dbConn.setAutoCommit(true);
        String line = null;
        while ((line = fin.readLine()) != null) {
            ++numObjects;
            String[] cols = line.split("\t");
            String key = cols[0];
            String pos = cols[1];
            if (isKeyInteger) {
                stmt.setLong(1, Integer.valueOf(key).intValue());
            } else {
                stmt.setString(1, key);
            }
            stmt.setLong(2, Long.valueOf(pos));
            stmt.execute();
            dbConn.commit();
            if (!isVerbose || numObjects % 10000L != 0L) continue;
            System.out.println(key + "    " + numObjects + ", avgBytesPerItem: " + numBytesRead / numObjects + ", MBs read: " + numBytesRead / MB + ", Mem (MBs): " + new IndexUtils().getMemoryUse() / MB);
        }
        while (line != null) {
        }
        fin.close();
        stmt.close();
        IndexDatabaseCreator.println("Num objects read: " + numObjects, isVerbose);
    }
}

