/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog;

import edu.mayo.bior.catalog.CatalogFileUtils;
import edu.mayo.bior.catalog.CatalogFormatException;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class CatalogFiles {
    private File mCatalogFile;
    private String mPrefix;
    private File mDir;
    private File mColumnsFile;
    private File mDataSourceFile;
    private File mTabixIndexFile;
    private File mBlacklistFile;
    private File mBlacklistBiorwebFile;
    private boolean isDeprecated;

    public CatalogFiles(String catalogPath) throws CatalogFormatException {
        this(new File(catalogPath));
    }

    public CatalogFiles(File catalogFile) throws CatalogFormatException {
        this.mCatalogFile = catalogFile;
        if (!this.mCatalogFile.exists()) {
            throw new CatalogFormatException(String.format("Catalog file '%s' does not exist", catalogFile.getPath()));
        }
        if (!this.mCatalogFile.isFile()) {
            throw new CatalogFormatException(String.format("Catalog file '%s' is not a file", catalogFile.getPath()));
        }
        if (!this.mCatalogFile.canRead()) {
            throw new CatalogFormatException(String.format("Can not read catalog file '%s'", catalogFile.getPath()));
        }
        this.setParentDir();
        this.setPrefix();
        this.mColumnsFile = this.setFileIfExists("columns", ".columns.tsv");
        this.mDataSourceFile = this.setFileIfExists("data source", ".datasource.properties");
        this.mTabixIndexFile = this.setFileIfExists("tabix index", ".tsv.bgz.tbi");
        this.mBlacklistFile = this.setFileIfExists("blacklist", ".columns.tsv.blacklist");
        this.mBlacklistBiorwebFile = this.setFileIfExists("blacklist biorweb", ".columns.tsv.blacklist.biorweb");
        this.isDeprecated = new File(this.mDir, this.getPrefix() + ".DEPRECATED.txt").exists();
    }

    public File getCatalogFile() {
        return this.mCatalogFile;
    }

    public File getColumnsFile() {
        return this.mColumnsFile;
    }

    public File getDataSourceFile() {
        return this.mDataSourceFile;
    }

    public File getTabixIndexFile() {
        return this.mTabixIndexFile;
    }

    public File getBlacklistFile() {
        return this.mBlacklistFile;
    }

    public File getBlacklistBiorwebFile() {
        return this.mBlacklistBiorwebFile;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public File getDir() {
        return this.mDir;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    private void setPrefix() throws CatalogFormatException {
        String catalogSuffix;
        String basename = this.mCatalogFile.getName();
        if (!basename.endsWith(catalogSuffix = ".tsv.bgz")) {
            throw new CatalogFormatException(String.format("Catalog file '%s' does not end with %s", this.mCatalogFile, catalogSuffix));
        }
        int indexOfCatalogSuffix = basename.indexOf(catalogSuffix);
        if (indexOfCatalogSuffix != -1 && indexOfCatalogSuffix + catalogSuffix.length() == basename.length()) {
            this.mPrefix = basename.substring(0, basename.indexOf(catalogSuffix));
            if (StringUtils.isEmpty((String)this.mPrefix)) {
                throw new CatalogFormatException(String.format("Could not extract catalog prefix from catalog file '%s'", this.mCatalogFile));
            }
        }
    }

    private void setParentDir() throws CatalogFormatException {
        this.mDir = CatalogFileUtils.getParent(this.mCatalogFile);
        if (!this.mDir.isDirectory()) {
            throw new CatalogFormatException(String.format("Could not get directory for catalog file '%s'", this.mCatalogFile));
        }
    }

    private File setFileIfExists(String description, String suffix) throws CatalogFormatException {
        File file = new File(this.mDir, this.getPrefix() + suffix);
        if (!file.exists()) {
            return null;
        }
        if (!file.isFile()) {
            throw new CatalogFormatException(String.format("%s file '%s' exists but is not a file", description, file.getPath()));
        }
        if (!file.canRead()) {
            throw new CatalogFormatException(String.format("Can not read %s file '%s'", description, file.getPath()));
        }
        return file;
    }
}

