/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.log4j.Logger;

public class CatalogFileUtils {
    private static final Logger sLogger = Logger.getLogger(CatalogFileUtils.class);

    public static BufferedReader getBufferedReader(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            String msg = String.format("Couldn't get buffered reader for '%s' because it does not exist", f.getPath());
            sLogger.error((Object)msg);
            return null;
        }
        if (!f.isFile()) {
            String msg = String.format("Couldn't get buffered reader for '%s' because it is not a file", f.getPath());
            sLogger.error((Object)msg);
            return null;
        }
        if (!f.canRead()) {
            String msg = String.format("Couldn't get buffered reader for '%s' because it is not readable", f.getPath());
            sLogger.error((Object)msg);
            return null;
        }
        BufferedReader r = null;
        try {
            r = f.getAbsoluteFile().getName().endsWith(".bgz") ? new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream((InputStream)new FileInputStream(f)))) : new BufferedReader(new FileReader(f));
        }
        catch (IOException e) {
            String msg = String.format("Couldn't get buffered reader for '%s'. Msg: '%s'", f.getPath(), e.getMessage());
            sLogger.error((Object)msg);
            return null;
        }
        return r;
    }

    public static boolean validSymLink(File f) {
        try {
            String resolvedFileNm = f.getCanonicalPath();
            if (resolvedFileNm == null || resolvedFileNm.length() == 0) {
                return false;
            }
        }
        catch (IOException io) {
            return false;
        }
        catch (SecurityException s) {
            return false;
        }
        return true;
    }

    public static File getParent(File f) {
        File parent = f.getParentFile();
        if (parent != null) {
            return parent;
        }
        return f.getAbsoluteFile().getParentFile();
    }

    public static List<File> findAllTsvBgzFiles(File rootDir, boolean exhaustive) {
        ArrayList<File> hits = new ArrayList<File>();
        ArrayList<Object> subdirs = new ArrayList<Object>();
        File[] nestedFiles = rootDir.listFiles();
        if (nestedFiles != null) {
            for (File f : nestedFiles) {
                if (f.isFile() && f.getName().toLowerCase().endsWith(".tsv.bgz")) {
                    hits.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                subdirs.add(f);
            }
        }
        if (exhaustive || hits.size() == 0) {
            for (File file : subdirs) {
                hits.addAll(CatalogFileUtils.findAllTsvBgzFiles(file, exhaustive));
            }
        }
        return hits;
    }
}

